/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village;

import java.io.File;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.village.VillageModuleClient;
import shadows.apotheosis.village.fletching.ApothFletchingBlock;
import shadows.apotheosis.village.fletching.FletchingContainer;
import shadows.apotheosis.village.fletching.FletchingRecipe;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowEntity;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowItem;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowEntity;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowItem;
import shadows.apotheosis.village.fletching.effects.BleedingEffect;
import shadows.apotheosis.village.wanderer.WandererReplacements;
import shadows.apotheosis.village.wanderer.WandererSpawnerExt;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;
import shadows.placebo.util.ReflectionHelper;

public class VillageModule {
    public static final IRecipeType<FletchingRecipe> FLETCHING = IRecipeType.func_222147_a((String)"apotheosis:fletching");
    public static final IRecipeSerializer<FletchingRecipe> FLETCHING_SERIALIZER = new FletchingRecipe.Serializer();
    public static Configuration config;
    public static boolean enableWandererSpawner;
    public static boolean enableNewTrades;

    @SubscribeEvent
    public void setup(Apotheosis.ApotheosisSetup e) {
        MinecraftForge.EVENT_BUS.addListener(WandererReplacements::replaceWandererArrays);
        MinecraftForge.EVENT_BUS.addGenericListener(World.class, this::starting);
        MinecraftForge.EVENT_BUS.addListener(ApotheosisObjects.OBSIDIAN_ARROW::handleArrowJoin);
        Map types = (Map)ReflectionHelper.getPrivateValue(PointOfInterestType.class, null, (String[])new String[]{"field_221073_u"});
        types.put(Blocks.field_222426_lO.func_176223_P(), PointOfInterestType.field_221061_i);
        config = new Configuration(new File(Apotheosis.configDir, "village.cfg"));
        WandererSpawnerExt.defaultChance = config.getInt("Spawn Chance", "Wanderer", 10, 1, 100, "The 1/100 chance the wandering trader has to spawn every attempt.  This chance is increased by it's own value each failure until successful.");
        WandererSpawnerExt.defaultDelay = config.getInt("Spawn Delay", "Wanderer", 24000, 1, Integer.MAX_VALUE, "The number of ticks that must elapse before a wanderer spawn attempt happens.");
        enableWandererSpawner = config.getBoolean("Enable Wanderer Spawner", "Wanderer", true, "If the Apotheosis Wanderer Spawner is enabled, instead of the default.");
        enableNewTrades = config.getBoolean("Enable New Trades", "Wanderer", true, "If new trades are added to the wandering merchant.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void setup(Apotheosis.ApotheosisClientSetup e) {
        VillageModuleClient.init();
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)FLETCHING_SERIALIZER.setRegistryName(FletchingRecipe.Serializer.NAME));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverrideBlock((Block)new ApothFletchingBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ObsidianArrowItem().setRegistryName("obsidian_arrow"), (Item)new BroadheadArrowItem().setRegistryName("broadhead_arrow")});
    }

    @SubscribeEvent
    public void entities(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().register(EntityType.Builder.func_220322_a(ObsidianArrowEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).func_220321_a(0.5f, 0.5f).setCustomClientFactory((se, w) -> new ObsidianArrowEntity((World)w)).func_206830_a("ob_arrow").setRegistryName("ob_arrow_entity"));
        e.getRegistry().register(EntityType.Builder.func_220322_a(BroadheadArrowEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).func_220321_a(0.5f, 0.5f).setCustomClientFactory((se, w) -> new BroadheadArrowEntity((World)w)).func_206830_a("bh_arrow").setRegistryName("bh_arrow_entity"));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<ContainerType<?>> e) {
        e.getRegistry().register(new ContainerType(FletchingContainer::new).setRegistryName("fletching"));
    }

    @SubscribeEvent
    public void effects(RegistryEvent.Register<Effect> e) {
        e.getRegistry().register(new BleedingEffect().setRegistryName("bleeding"));
    }

    public void starting(AttachCapabilitiesEvent<World> e) {
        if (enableWandererSpawner && e.getObject() instanceof ServerWorld) {
            ServerWorld w = (ServerWorld)e.getObject();
            if (w.field_73011_w.func_186058_p() == DimensionType.field_223227_a_) {
                ReflectionHelper.setPrivateValue(ServerWorld.class, (Object)w, (Object)((Object)new WandererSpawnerExt(w)), (String[])new String[]{"field_217496_L", "wanderingTraderSpawner"});
            }
        }
    }

    static {
        enableWandererSpawner = true;
        enableNewTrades = true;
    }
}

