/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.oldjava;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;

public final class Utils {
    private static final File LOCK = new File("stop-java-detection.txt");

    public static boolean isLocked() {
        return LOCK.exists();
    }

    public static void writeLock() {
        try (FileWriter writer = new FileWriter(LOCK);){
            writer.write("If this file exists, the old java version popup will not be shown. This should not be included with modpacks by default!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isJvm64bit() {
        String[] propertyStrings;
        for (String property : propertyStrings = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String value = System.getProperty(property);
            if (value == null || !value.contains("64")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRam(long recommended) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        return recommended <= maxMemory;
    }

    public static boolean compareJava(String target) {
        return target.compareTo(System.getProperty("java.version")) > 0;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static long getMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static void createWarning(String message, String title, String url, String readMore, String ignore, String stop, Path file) {
        try {
            ProcessBuilder builder = new ProcessBuilder(System.getProperty("java.home") + "/bin/java", "-jar", file.toString(), message, title, url, readMore, ignore, stop);
            builder.inheritIO();
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

