/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.oldjava.minecraft;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue checkJavaVersion;
    private final ForgeConfigSpec.ConfigValue<String> minJavaVersion;
    private final ForgeConfigSpec.BooleanValue check32Bit;
    private final ForgeConfigSpec.BooleanValue checkMinMemory;
    private final ForgeConfigSpec.ConfigValue<Integer> recommendedRam;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Settings related to checking for a very specific Minecraft version.");
        builder.push("java-version");
        builder.comment("Whether or not the Java version should be checked.");
        this.checkJavaVersion = builder.define("enabled", true);
        builder.comment("What is the minimum version of Java to look for?");
        this.minJavaVersion = builder.define("minVersion", (Object)"1.8.0_162");
        builder.pop();
        builder.comment("Settings related to the Java architecture.");
        builder.push("jvm-architecture");
        builder.comment("Should people using 32 bit Java be warned and asked to use 64 bit Java instead?");
        this.check32Bit = builder.define("warn32Bit", true);
        builder.pop();
        builder.comment("Settings related to Java's memory management.");
        builder.push("memory");
        builder.comment("Should users with low RAM be warned?");
        this.checkMinMemory = builder.define("warnLowMemory", true);
        builder.comment("The amount of recommended ram to play the pack. This is in megabytes.");
        this.recommendedRam = builder.define("recommendedRam", (Object)1024);
        builder.pop();
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean checkJavaVersion() {
        return (Boolean)this.checkJavaVersion.get();
    }

    public String getMinJavaVersion() {
        return (String)this.minJavaVersion.get();
    }

    public boolean check32Bit() {
        return (Boolean)this.check32Bit.get();
    }

    public boolean checkLowMemory() {
        return (Boolean)this.checkMinMemory.get();
    }

    public long getRecommenedMemory() {
        return (long)((Integer)this.recommendedRam.get()).intValue() * 1000000L;
    }

    public void forceLoad(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        this.spec.setConfig((CommentedConfig)configData);
    }
}

