/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.block;

import com.farcr.swampexpansion.common.block.DoubleCattailBlock;
import com.farcr.swampexpansion.common.block.DoubleRiceBlock;
import com.farcr.swampexpansion.core.other.SwampExTags;
import com.farcr.swampexpansion.core.registry.SwampExBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class RiceBlock
extends BushBlock
implements IWaterLoggable,
IGrowable,
IPlantable {
    protected static final VoxelShape SHAPE_SHORT = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    protected static final VoxelShape SHAPE_MEDIUM = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape SHAPE_TALL = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)5);

    public RiceBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE, WATERLOGGED});
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        if (worldIn.func_204610_c(pos).func_206882_g() == 8 && block.func_203417_a(SwampExTags.CATTAIL_PLANTABLE_ON)) {
            return true;
        }
        return block.getBlock() == Blocks.field_150458_ak;
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int flags) {
        Random rand = new Random();
        int type = rand.nextInt(7);
        BlockState rice = ((Block)SwampExBlocks.RICE.get()).func_176223_P();
        BlockState tall_up = (BlockState)((Block)SwampExBlocks.TALL_RICE.get()).func_176223_P().func_206870_a(DoubleCattailBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
        BlockState tall_down = (BlockState)((Block)SwampExBlocks.TALL_RICE.get()).func_176223_P().func_206870_a(DoubleCattailBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
        boolean waterlogged = worldIn.func_201671_F(pos);
        if (type != 0 || !worldIn.func_180495_p(pos.func_177984_a()).func_196958_f()) {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)rice.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(3 + rand.nextInt(3))), flags);
        } else {
            int age = 6 + rand.nextInt(2);
            worldIn.func_180501_a(pos, (BlockState)((BlockState)tall_down.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).func_206870_a((IProperty)DoubleRiceBlock.AGE, (Comparable)Integer.valueOf(age)), flags);
            waterlogged = worldIn.func_201671_F(pos.func_177984_a());
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)tall_up.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).func_206870_a((IProperty)DoubleRiceBlock.AGE, (Comparable)Integer.valueOf(age)), flags);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= 4 ? SHAPE_TALL : ((Integer)state.func_177229_b((IProperty)AGE) >= 1 ? SHAPE_MEDIUM : SHAPE_SHORT);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int newAge = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
        if (newAge > 7) {
            newAge = 7;
        }
        if (newAge <= 5 || !worldIn.func_180495_p(pos.func_177984_a()).func_196958_f()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(newAge)));
        } else {
            DoubleRiceBlock doubleplantblock = (DoubleRiceBlock)SwampExBlocks.TALL_RICE.get();
            IFluidState ifluidstateUp = worldIn.func_204610_c(pos.func_177984_a());
            if (doubleplantblock.func_176223_P().func_196955_c((IWorldReader)worldIn, pos) && (worldIn.func_175623_d(pos.func_177984_a()) || Boolean.valueOf(ifluidstateUp.func_206884_a(FluidTags.field_206959_a) && ifluidstateUp.func_206882_g() == 8).booleanValue())) {
                doubleplantblock.placeAt((IWorld)worldIn, pos, 2, newAge);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int chance;
        super.func_225534_a_(state, worldIn, pos, random);
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        int n = chance = worldIn.func_180495_p(pos.func_177977_b()).isFertile((IBlockReader)worldIn, pos.func_177977_b()) ? 10 : 12;
        if ((worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak || worldIn.func_204610_c(pos).func_206882_g() == 8) && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(chance) == 0 ? 1 : 0) != 0)) {
            if (i == 5) {
                DoubleRiceBlock doubleplantblock = (DoubleRiceBlock)SwampExBlocks.TALL_RICE.get();
                if (doubleplantblock.func_176223_P().func_196955_c((IWorldReader)worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a())) {
                    doubleplantblock.placeAt((IWorld)worldIn, pos, 2, 6);
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                }
            } else {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)));
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return this.func_200014_a_(world.func_180495_p(pos.func_177977_b()), (IBlockReader)world, pos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return ((Block)SwampExBlocks.RICE.get()).func_176223_P();
    }
}

