/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.entity;

import com.farcr.swampexpansion.common.entity.SlabfishOverlay;
import com.farcr.swampexpansion.common.entity.SlabfishRarity;
import com.farcr.swampexpansion.common.entity.SlabfishType;
import com.farcr.swampexpansion.common.entity.goals.SlabbyBreedGoal;
import com.farcr.swampexpansion.common.entity.goals.SlabbyFollowParentGoal;
import com.farcr.swampexpansion.common.entity.goals.SlabbyGrabItemGoal;
import com.farcr.swampexpansion.common.item.MudBallItem;
import com.farcr.swampexpansion.core.SwampExpansion;
import com.farcr.swampexpansion.core.other.SwampExCriteriaTriggers;
import com.farcr.swampexpansion.core.other.SwampExTags;
import com.farcr.swampexpansion.core.registry.SwampExBiomes;
import com.farcr.swampexpansion.core.registry.SwampExBlocks;
import com.farcr.swampexpansion.core.registry.SwampExEntities;
import com.farcr.swampexpansion.core.registry.SwampExItems;
import com.farcr.swampexpansion.core.registry.SwampExSounds;
import com.google.common.collect.Maps;
import com.teamabnormals.abnormals_core.core.library.api.IBucketableEntity;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import com.teamabnormals.abnormals_core.core.library.endimator.entity.IEndimatedEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.EggItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.NameTagItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SlabfishEntity
extends TameableEntity
implements IInventoryChangedListener,
IBucketableEntity,
IEndimatedEntity {
    private static final DataParameter<Integer> SLABFISH_TYPE = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SLABFISH_OVERLAY = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PRE_NAME_TYPE = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_BACKPACK = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BACKPACK_COLOR = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> BACKPACK_USED = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> HAS_SWEATER = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SWEATER_COLOR = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final EntitySize SIZE_SWIMMING = EntitySize.func_220311_c((float)0.75f, (float)0.25f);
    public static final EntitySize SIZE_SITTING = EntitySize.func_220311_c((float)0.45f, (float)0.6f);
    public static final EntitySize SIZE_SWIMMING_CHILD = EntitySize.func_220311_c((float)0.375f, (float)0.125f);
    public static final EntitySize SIZE_SITTING_CHILD = EntitySize.func_220311_c((float)0.225f, (float)0.3f);
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196088_aY, (IItemProvider)SwampExItems.TROPICAL_FISH_KELP_ROLL.get()});
    private static final Ingredient HEALING_ITEMS = Ingredient.func_199805_a((Tag)ItemTags.field_206964_G);
    private static final Ingredient SPEEDING_ITEMS = Ingredient.func_199805_a(SwampExTags.SUSHI);
    private static final Ingredient FOOD_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("atmospheric", "passionfruit")), (IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("atmospheric", "shimmering_passionfruit")), (IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("endergetic", "bolloom_fruit")), Items.field_185161_cS});
    private static final Collection<Ingredient> TEMPT = new ArrayList<Ingredient>();
    private Endimation playingEndimation = BLANK_ANIMATION;
    public static final Endimation DANCE = new Endimation(SwampExpansion.REGISTRY_HELPER.prefix("slabfish_dancing"), 40);
    public Inventory slabfishBackpack;
    private UUID lightningUUID;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    private int animationTick;
    public boolean isPartying = false;
    BlockPos jukeboxPosition;
    private static final Map<List<String>, SlabfishType> NAMES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), skins -> {
        skins.put(Arrays.asList("cameron", "cam", "cringe"), SlabfishType.CAMERON);
        skins.put(Arrays.asList("bagel", "shyguy", "shy guy", "bagielo"), SlabfishType.BAGEL);
        skins.put(Arrays.asList("gore", "gore.", "musicano"), SlabfishType.GORE);
        skins.put(Arrays.asList("snake", "snake block", "snakeblock"), SlabfishType.SNAKE_BLOCK);
        skins.put(Arrays.asList("jackson", "jason", "json"), SlabfishType.JACKSON);
        skins.put(Arrays.asList("jub", "slabrave", "mista jub"), SlabfishType.MISTA_JUB);
        skins.put(Arrays.asList("smelly", "stinky", "smellysox", "thefaceofgaming"), SlabfishType.SMELLY);
        skins.put(Arrays.asList("squart", "squar", "squarticus"), SlabfishType.SQUART);
    });
    private LazyOptional<?> itemHandler = null;
    private static final Map<Item, DyeColor> SWEATER_MAP = (Map)Util.func_200696_a((Object)Maps.newHashMap(), sweaterMap -> {
        sweaterMap.put(Items.field_221603_aE, DyeColor.WHITE);
        sweaterMap.put(Items.field_221604_aF, DyeColor.ORANGE);
        sweaterMap.put(Items.field_221605_aG, DyeColor.MAGENTA);
        sweaterMap.put(Items.field_221606_aH, DyeColor.LIGHT_BLUE);
        sweaterMap.put(Items.field_221607_aI, DyeColor.YELLOW);
        sweaterMap.put(Items.field_221608_aJ, DyeColor.LIME);
        sweaterMap.put(Items.field_221609_aK, DyeColor.PINK);
        sweaterMap.put(Items.field_221610_aL, DyeColor.GRAY);
        sweaterMap.put(Items.field_221611_aM, DyeColor.LIGHT_GRAY);
        sweaterMap.put(Items.field_221612_aN, DyeColor.CYAN);
        sweaterMap.put(Items.field_221613_aO, DyeColor.PURPLE);
        sweaterMap.put(Items.field_221614_aP, DyeColor.BLUE);
        sweaterMap.put(Items.field_221615_aQ, DyeColor.BROWN);
        sweaterMap.put(Items.field_221616_aR, DyeColor.GREEN);
        sweaterMap.put(Items.field_221617_aS, DyeColor.RED);
        sweaterMap.put(Items.field_221618_aT, DyeColor.BLACK);
    });
    private static final Map<DyeColor, Item> REVERSE_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DyeColor.class), reverseMap -> {
        reverseMap.put(DyeColor.WHITE, Items.field_221603_aE);
        reverseMap.put(DyeColor.ORANGE, Items.field_221604_aF);
        reverseMap.put(DyeColor.MAGENTA, Items.field_221605_aG);
        reverseMap.put(DyeColor.LIGHT_BLUE, Items.field_221606_aH);
        reverseMap.put(DyeColor.YELLOW, Items.field_221607_aI);
        reverseMap.put(DyeColor.LIME, Items.field_221608_aJ);
        reverseMap.put(DyeColor.PINK, Items.field_221609_aK);
        reverseMap.put(DyeColor.GRAY, Items.field_221610_aL);
        reverseMap.put(DyeColor.LIGHT_GRAY, Items.field_221611_aM);
        reverseMap.put(DyeColor.CYAN, Items.field_221612_aN);
        reverseMap.put(DyeColor.PURPLE, Items.field_221613_aO);
        reverseMap.put(DyeColor.BLUE, Items.field_221614_aP);
        reverseMap.put(DyeColor.BROWN, Items.field_221615_aQ);
        reverseMap.put(DyeColor.GREEN, Items.field_221616_aR);
        reverseMap.put(DyeColor.RED, Items.field_221617_aS);
        reverseMap.put(DyeColor.BLACK, Items.field_221618_aT);
    });

    public SlabfishEntity(EntityType<? extends SlabfishEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.initSlabfishBackpack();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    protected void func_184651_r() {
        TEMPT.add(BREEDING_ITEMS);
        TEMPT.add(HEALING_ITEMS);
        TEMPT.add(SPEEDING_ITEMS);
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, EvokerEntity.class, 12.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, VindicatorEntity.class, 8.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, RavagerEntity.class, 8.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, VexEntity.class, 8.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PillagerEntity.class, 15.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, IllusionerEntity.class, 12.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(4, (Goal)new SlabbyBreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new SlabbyGrabItemGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.merge(TEMPT)));
        this.field_70714_bg.func_75776_a(8, (Goal)new SlabbyFollowParentGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SLABFISH_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(SLABFISH_OVERLAY, (Object)0);
        this.func_184212_Q().func_187214_a(PRE_NAME_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(FROM_BUCKET, (Object)false);
        this.func_184212_Q().func_187214_a(HAS_BACKPACK, (Object)false);
        this.func_184212_Q().func_187214_a(BACKPACK_COLOR, (Object)DyeColor.BROWN.func_196059_a());
        this.func_184212_Q().func_187214_a(BACKPACK_USED, (Object)new ItemStack((IItemProvider)Items.field_221675_bZ));
        this.func_184212_Q().func_187214_a(HAS_SWEATER, (Object)false);
        this.func_184212_Q().func_187214_a(SWEATER_COLOR, (Object)DyeColor.WHITE.func_196059_a());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SlabfishType", this.getSlabfishType().getId());
        compound.func_74768_a("SlabfishOverlay", this.getSlabfishOverlay().getId());
        compound.func_74768_a("PreNameType", this.getPreNameType().getId());
        compound.func_74757_a("FromBucket", this.isFromBucket());
        compound.func_74757_a("HasBackpack", this.hasBackpack());
        compound.func_74774_a("BackpackColor", (byte)this.getBackpackColor().func_196059_a());
        CompoundNBT itemstackTag = new CompoundNBT();
        this.getBackpackItem().func_77955_b(itemstackTag);
        compound.func_218657_a("BackpackItem", (INBT)itemstackTag);
        compound.func_74757_a("HasSweater", this.hasSweater());
        compound.func_74774_a("SweaterColor", (byte)this.getSweaterColor().func_196059_a());
        if (this.hasBackpack()) {
            ListNBT listnbt = new ListNBT();
            for (int i = 0; i < this.slabfishBackpack.func_70302_i_(); ++i) {
                ItemStack itemstack = this.slabfishBackpack.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(compoundnbt);
                listnbt.add((Object)compoundnbt);
            }
            compound.func_218657_a("Items", (INBT)listnbt);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSlabfishType(SlabfishType.byId(compound.func_74762_e("SlabfishType")));
        this.setSlabfishOverlay(SlabfishOverlay.byId(compound.func_74762_e("SlabfishOverlay")));
        this.setPreNameType(SlabfishType.byId(compound.func_74762_e("PreNameType")));
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        this.setBackpacked(compound.func_74767_n("HasBackpack"));
        if (compound.func_150297_b("BackpackColor", 99)) {
            this.setBackpackColor(DyeColor.func_196056_a((int)compound.func_74762_e("BackpackColor")));
        }
        ItemStack backpackItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BackpackItem"));
        this.setBackpackItem(backpackItem);
        this.setSweatered(compound.func_74767_n("HasSweater"));
        if (compound.func_150297_b("SweaterColor", 99)) {
            this.setSweaterColor(DyeColor.func_196056_a((int)compound.func_74762_e("SweaterColor")));
        }
        if (this.hasBackpack()) {
            ListNBT listnbt = compound.func_150295_c("Items", 10);
            this.initSlabfishBackpack();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                int j = compoundnbt.func_74771_c("Slot") & 0xFF;
                if (j >= this.slabfishBackpack.func_70302_i_()) continue;
                this.slabfishBackpack.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
            }
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        this.initSlabfishBackpack();
        if (item instanceof SpawnEggItem || item instanceof NameTagItem || item == Items.field_196088_aY || item == SwampExItems.TROPICAL_FISH_KELP_ROLL.get() || item instanceof EggItem || item instanceof MudBallItem) {
            return super.func_184645_a(player, hand);
        }
        if (item instanceof DyeItem && this.hasBackpack()) {
            DyeColor dyecolor = ((DyeItem)item).func_195962_g();
            if (dyecolor != this.getBackpackColor()) {
                this.setBackpackColor(dyecolor);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
            return true;
        }
        if (item == Items.field_179556_br && !player.func_184207_aI()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_184220_m((Entity)player);
            this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.particleCloud((IParticleData)ParticleTypes.field_218417_ae);
            return true;
        }
        if (!(!SWEATER_MAP.containsKey(item) || this.hasSweater() && this.getSweaterColor() == SWEATER_MAP.get(item) || player.func_226563_dT_())) {
            Item previousSweater = Items.field_190931_a;
            this.playSweaterSound();
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.hasSweater()) {
                previousSweater = (IItemProvider)REVERSE_MAP.get(this.getSweaterColor());
            }
            this.setSweaterColor(SWEATER_MAP.get(item));
            if (!this.hasSweater()) {
                this.setSweatered(true);
            } else {
                this.dropItem((IItemProvider)previousSweater);
                this.playSweaterSound();
            }
            return true;
        }
        if (item.func_206844_a(Tags.Items.CHESTS_WOODEN) && !this.hasBackpack()) {
            this.setBackpacked(true);
            this.setBackpackItem(itemstack);
            this.playBackpackSound();
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
                if (!this.field_70170_p.func_201670_d()) {
                    SwampExCriteriaTriggers.BACKPACK_SLABFISH.trigger(serverplayerentity);
                }
            }
            return true;
        }
        if (item == Items.field_151097_aZ && this.hasSweater() && !player.func_226563_dT_()) {
            this.setSweatered(false);
            this.playSweaterSound();
            this.dropItem((IItemProvider)REVERSE_MAP.get(this.getSweaterColor()));
            if (!this.field_70170_p.field_72995_K) {
                itemstack.func_222118_a(1, (LivingEntity)player, tool -> tool.func_213334_d(hand));
            }
            return true;
        }
        if (item == Items.field_151097_aZ && this.hasBackpack() && player.func_226563_dT_()) {
            this.setBackpackColor(DyeColor.BROWN);
            this.dropBackpack();
            this.setBackpacked(false);
            this.playBackpackSound();
            this.slabfishBackpack.func_174888_l();
            if (!this.field_70170_p.field_72995_K) {
                itemstack.func_222118_a(1, (LivingEntity)player, tool -> tool.func_213334_d(hand));
            }
            return true;
        }
        if (item == Items.field_151131_as && this.func_70089_S()) {
            if (this.func_70874_b() < 0) {
                return false;
            }
            if (this.hasBackpack()) {
                this.setBackpackColor(DyeColor.BROWN);
                this.dropBackpack();
                this.setBackpacked(false);
                this.slabfishBackpack.func_174888_l();
            }
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getBucket();
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return true;
        }
        if (item.func_206844_a(ItemTags.field_219774_K)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.playBurpSound();
            this.particleCloud((IParticleData)ParticleTypes.field_197597_H);
            this.dropItem((IItemProvider)SwampExItems.MUSIC_DISC_SLABRAVE.get());
            return true;
        }
        if (HEALING_ITEMS.test(itemstack) && itemstack.func_222117_E() && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SwampExSounds.ENTITY_SLABFISH_EAT.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
            this.func_70691_i(item.func_219967_s().func_221466_a());
            this.particleCloud((IParticleData)ParticleTypes.field_218420_D);
            return true;
        }
        if (SPEEDING_ITEMS.test(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.playBurpSound();
            this.func_195064_c(new EffectInstance(Effects.field_76424_c, 3600, 2, true, true));
            this.particleCloud((IParticleData)ParticleTypes.field_197613_f);
            return true;
        }
        if (FOOD_ITEMS.test(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SwampExSounds.ENTITY_SLABFISH_EAT.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
            return true;
        }
        if (!this.func_70906_o() && this.hasBackpack() && player.func_226563_dT_() && !this.func_70090_H()) {
            this.func_70903_f(true);
            this.func_184754_b(player.func_110124_au());
            if (!this.field_70170_p.func_201670_d()) {
                this.field_70911_d.func_75270_a(true);
            }
            return true;
        }
        if (this.func_70906_o() && player.func_226563_dT_()) {
            if (!this.field_70170_p.func_201670_d()) {
                this.field_70911_d.func_75270_a(false);
            }
            this.func_70903_f(false);
            return true;
        }
        if (this.hasBackpack()) {
            this.openGUI(player);
            player.func_184597_cx();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_191955_a(BlockState state) {
        if (state.func_177230_c() == SwampExBlocks.MUD.get() && this.getSlabfishOverlay() != SlabfishOverlay.MUDDY) {
            this.setSlabfishOverlay(SlabfishOverlay.MUDDY);
        }
        if (state.func_177230_c() == Blocks.field_150355_j && this.getSlabfishOverlay() != SlabfishOverlay.NONE) {
            this.setSlabfishOverlay(SlabfishOverlay.NONE);
        }
    }

    public boolean isPartying() {
        return this.isPartying;
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70128_L && !this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && livingentity != null) {
                livingentity.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            if (entity != null) {
                entity.func_70074_a((LivingEntity)this);
            }
            if (this.func_70608_bn()) {
                this.func_213366_dy();
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (!this.field_70170_p.field_72995_K) {
                this.func_213345_d(cause);
                this.func_226298_f_(livingentity);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_213301_b(Pose.DYING);
        }
    }

    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isPartying = isPartying;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jukeboxPosition == null || !this.jukeboxPosition.func_218137_a((IPosition)this.func_213303_ch(), 3.46) || this.field_70170_p.func_180495_p(this.jukeboxPosition).func_177230_c() != Blocks.field_150421_aI) {
            this.isPartying = false;
            this.jukeboxPosition = null;
        }
        if (!this.func_70906_o()) {
            this.func_70903_f(false);
        }
        if (this.func_70090_H() && this.func_184187_bx() != null) {
            this.func_184210_p();
        }
        if (this.isMoving() && this.func_70644_a(Effects.field_76424_c) && this.field_70146_Z.nextInt(3) == 0 && !this.func_70090_H()) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226282_d_(0.5), this.func_226278_cu_() + 0.2, this.func_226287_g_(0.5), d0, d1, d2);
        }
        if (this.field_70146_Z.nextFloat() < 0.1f && this.getSlabfishOverlay() == SlabfishOverlay.MUDDY) {
            for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                this.doParticle(this.field_70170_p, this.func_226277_ct_() - (double)0.3f, this.func_226277_ct_() + (double)0.3f, this.func_226281_cx_() - (double)0.3f, this.func_226281_cx_() + (double)0.3f, this.func_226283_e_(0.5), (IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)SwampExItems.MUD_BALL.get())));
            }
        }
        List playerList = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0));
        for (PlayerEntity player : playerList) {
            if (!(player instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            if (this.field_70170_p.func_201670_d()) continue;
            if (this.getSlabfishType() == SlabfishType.SWAMP) {
                SwampExCriteriaTriggers.SWAMP_SLABFISH.trigger(serverplayerentity);
            }
            if (this.getSlabfishType() != SlabfishType.MARSH) continue;
            SwampExCriteriaTriggers.MARSH_SLABFISH.trigger(serverplayerentity);
        }
        this.func_213323_x_();
        this.func_98053_h(this.hasBackpack());
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        Vec3d vec3d = this.func_213322_ci();
        if (!this.field_70122_E && vec3d.field_72448_b < 0.0) {
            this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    private boolean isMoving() {
        return this.func_213322_ci().func_82615_a() > 0.0 || this.func_213322_ci().func_82617_b() > 0.0 || this.func_213322_ci().func_82616_c() > 0.0;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null) {
            if (this.func_184187_bx() instanceof BoatEntity) {
                return 0.3;
            }
            return 0.52f;
        }
        return super.func_70033_W();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SwampExSounds.ENTITY_SLABFISH_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SwampExSounds.ENTITY_SLABFISH_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)SwampExSounds.ENTITY_SLABFISH_STEP.get(), 0.15f, 1.0f);
    }

    protected void playBackpackSound() {
        this.func_184185_a((SoundEvent)SwampExSounds.ENTITY_SLABFISH_BACKPACK.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playSweaterSound() {
        this.func_184185_a((SoundEvent)SwampExSounds.ENTITY_SLABFISH_SWEATER.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playBurpSound() {
        this.func_184185_a((SoundEvent)SwampExSounds.ENTITY_SLABFISH_BURP.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    private void doParticle(World world, double p_226397_2_, double p_226397_4_, double p_226397_6_, double p_226397_8_, double p_226397_10_, IParticleData p_226397_12_) {
        world.func_195594_a(p_226397_12_, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)p_226397_2_, (double)p_226397_4_), p_226397_10_, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)p_226397_6_, (double)p_226397_8_), 0.0, 0.0, 0.0);
    }

    private void particleCloud(IParticleData particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(particle, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    private void dropItem(IItemProvider item) {
        ItemEntity itementity = this.func_199702_a(item, 0);
        if (itementity != null) {
            itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
        }
    }

    public SlabfishEntity createChild(AgeableEntity ageable) {
        SlabfishEntity baby = (SlabfishEntity)((EntityType)SwampExEntities.SLABFISH.get()).func_200721_a(this.field_70170_p);
        baby.setSlabfishType(this.getSlabfishType());
        baby.setPreNameType(this.getSlabfishType());
        return baby;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SwampExItems.SLABFISH_SPAWN_EGG.get());
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    public EntitySize func_213305_a(Pose pose) {
        return this.func_70090_H() ? (this.func_70631_g_() ? SIZE_SWIMMING_CHILD : SIZE_SWIMMING) : (this.func_70906_o() || this.func_184187_bx() != null ? (this.func_70631_g_() ? SIZE_SITTING_CHILD : SIZE_SITTING) : super.func_213305_a(pose));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70906_o() ? sizeIn.field_220316_b * 0.6f : sizeIn.field_220316_b * 0.8f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public int func_70641_bl() {
        return 5;
    }

    protected float func_189749_co() {
        return 0.96f;
    }

    public SlabfishType getTypeForConditions(IWorld world) {
        BlockPos pos = new BlockPos((Entity)this);
        Biome biome = world.func_226691_t_(pos);
        ArrayList<IForgeRegistryEntry> MARSH = new ArrayList<IForgeRegistryEntry>();
        MARSH.add(SwampExBiomes.MARSH.get());
        MARSH.add(SwampExBiomes.MUSHROOM_MARSH.get());
        ArrayList<Biome> ROSEWOOD = new ArrayList<Biome>();
        ROSEWOOD.add(this.findBiome("atmospheric", "rosewood_forest"));
        ROSEWOOD.add(this.findBiome("atmospheric", "rosewood_mountains"));
        ROSEWOOD.add(this.findBiome("atmospheric", "rosewood_plateau"));
        ROSEWOOD.add(this.findBiome("atmospheric", "rosewood_forest_plateau"));
        ArrayList<Biome> DUNES = new ArrayList<Biome>();
        DUNES.add(this.findBiome("atmospheric", "dunes"));
        DUNES.add(this.findBiome("atmospheric", "dunes_hills"));
        DUNES.add(this.findBiome("atmospheric", "petrified_dunes"));
        DUNES.add(this.findBiome("atmospheric", "rocky_dunes"));
        DUNES.add(this.findBiome("atmospheric", "rocky_dunes_hills"));
        DUNES.add(this.findBiome("atmospheric", "flourishing_dunes"));
        ArrayList<Biome> MAPLE = new ArrayList<Biome>();
        MAPLE.add(this.findBiome("autumnity", "maple_forest"));
        MAPLE.add(this.findBiome("autumnity", "maple_forest_hills"));
        MAPLE.add(this.findBiome("autumnity", "pumpkin_fields"));
        ArrayList<Biome> POISE = new ArrayList<Biome>();
        POISE.add(this.findBiome("endergetic", "poise_forest"));
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            if (((ServerWorld)this.field_70170_p).func_217475_c_(pos) != null) {
                return SlabfishType.TOTEM;
            }
            if (pos.func_177956_o() <= 20 && world.func_201696_r(pos) == 0) {
                return SlabfishType.CAVE;
            }
            if (pos.func_177956_o() >= 200) {
                return SlabfishType.SKY;
            }
            if (MARSH.contains(biome)) {
                return SlabfishType.MARSH;
            }
            if (MAPLE.contains(biome)) {
                return SlabfishType.MAPLE;
            }
            if (ROSEWOOD.contains(biome)) {
                return SlabfishType.ROSEWOOD;
            }
            if (DUNES.contains(biome)) {
                return SlabfishType.DUNES;
            }
            if (biome == Biomes.field_185445_W) {
                return SlabfishType.ICE_SPIKES;
            }
            if (biome == Biomes.field_150585_R || biome == Biomes.field_185430_ab) {
                return SlabfishType.DARK_FOREST;
            }
            if (biome == Biomes.field_185444_T) {
                return SlabfishType.FLOWER_FOREST;
            }
            if (biome.func_201856_r() == Biome.Category.OCEAN) {
                if (pos.func_177956_o() <= 50 && world.func_204610_c(pos).func_206882_g() == 8) {
                    return SlabfishType.DROWNED;
                }
                if (biome == Biomes.field_76776_l || biome == Biomes.field_203620_Z) {
                    return SlabfishType.FROZEN_OCEAN;
                }
                if (biome == Biomes.field_203614_T || biome == Biomes.field_203617_W) {
                    return SlabfishType.WARM_OCEAN;
                }
                return SlabfishType.OCEAN;
            }
            if (biome.func_201856_r() == Biome.Category.JUNGLE) {
                if (biome == Biomes.field_222370_aw || biome == Biomes.field_222371_ax) {
                    return SlabfishType.BAMBOO;
                }
                return SlabfishType.JUNGLE;
            }
            if (biome.func_201856_r() == Biome.Category.MUSHROOM) {
                return SlabfishType.MUSHROOM;
            }
            if (biome.func_201856_r() == Biome.Category.RIVER) {
                return SlabfishType.RIVER;
            }
            if (biome.func_201856_r() == Biome.Category.BEACH) {
                return SlabfishType.BEACH;
            }
            if (biome.func_201856_r() == Biome.Category.SAVANNA) {
                return SlabfishType.SAVANNA;
            }
            if (biome.func_201856_r() == Biome.Category.MESA) {
                return SlabfishType.BADLANDS;
            }
            if (biome.func_201856_r() == Biome.Category.ICY) {
                return SlabfishType.SNOWY;
            }
            if (biome.func_201856_r() == Biome.Category.DESERT) {
                return SlabfishType.DESERT;
            }
            if (biome.func_201856_r() == Biome.Category.TAIGA) {
                return SlabfishType.TAIGA;
            }
            if (biome.func_201856_r() == Biome.Category.FOREST) {
                return SlabfishType.FOREST;
            }
            if (biome.func_201856_r() == Biome.Category.PLAINS) {
                return SlabfishType.PLAINS;
            }
            if (biome.func_201856_r() == Biome.Category.EXTREME_HILLS || biome == Biomes.field_150576_N) {
                return SlabfishType.MOUNTAIN;
            }
        }
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223228_b_) {
            return SlabfishType.NETHER;
        }
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223229_c_) {
            if (POISE.contains(biome)) {
                return SlabfishType.POISE;
            }
            if (biome == Biomes.field_201938_R) {
                return SlabfishType.CHORUS;
            }
            return SlabfishType.END;
        }
        return SlabfishType.SWAMP;
    }

    public SlabfishType getRandomType() {
        boolean flag = false;
        SlabfishType type = SlabfishType.SWAMP;
        float chance = this.field_70146_Z.nextFloat();
        SlabfishRarity rarity = SlabfishRarity.COMMON;
        rarity = (double)chance > 0.45 ? ((double)chance > 0.75 ? ((double)chance > 0.9 ? ((double)chance > 0.98 ? SlabfishRarity.LEGENDARY : SlabfishRarity.EPIC) : SlabfishRarity.RARE) : SlabfishRarity.UNCOMMON) : SlabfishRarity.COMMON;
        while (!flag) {
            type = SlabfishType.getRandomFromRarity(rarity, this.field_70146_Z);
            if (!(type != SlabfishType.DUNES && type != SlabfishType.ROSEWOOD || ModList.get().isLoaded("atmospheric"))) {
                flag = false;
                continue;
            }
            if (type == SlabfishType.POISE && !ModList.get().isLoaded("endergetic")) {
                flag = false;
                continue;
            }
            if (type == SlabfishType.MAPLE && !ModList.get().isLoaded("autumnity")) {
                flag = false;
                continue;
            }
            if (type == SlabfishType.BAGEL || type == SlabfishType.CAMERON || type == SlabfishType.GORE || type == SlabfishType.SNAKE_BLOCK || type == SlabfishType.SMELLY || type == SlabfishType.SQUART || type == SlabfishType.MISTA_JUB || type == SlabfishType.JACKSON) {
                flag = false;
                continue;
            }
            flag = true;
        }
        return type;
    }

    public Biome findBiome(String modid, String name) {
        return (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(modid, name));
    }

    public SlabfishType getTypeForBreeding(IWorld world, SlabfishEntity parent1, SlabfishEntity parent2) {
        BlockPos pos = new BlockPos((Entity)this);
        Biome biome = world.func_226691_t_(pos);
        if (parent1.getSlabfishType() == SlabfishType.SKELETON && parent2.getSlabfishType() == SlabfishType.SKELETON) {
            if (world.func_201675_m().func_186058_p() == DimensionType.field_223228_b_) {
                return SlabfishType.WITHER;
            }
            if (world.func_226691_t_(pos).func_201856_r() == Biome.Category.ICY) {
                return SlabfishType.STRAY;
            }
        }
        if (this.getTypeForConditions(world) == SlabfishType.SWAMP && biome.func_201856_r() != Biome.Category.SWAMP) {
            if (this.field_70146_Z.nextBoolean()) {
                return parent1.getSlabfishType();
            }
            return parent2.getSlabfishType();
        }
        if (this.field_70146_Z.nextBoolean()) {
            return this.getTypeForConditions(world);
        }
        if (this.field_70146_Z.nextBoolean()) {
            return parent1.getSlabfishType();
        }
        return parent2.getSlabfishType();
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (name != null && this.getSlabfishType() != SlabfishType.GHOST) {
            super.func_200203_b(name);
            for (Map.Entry<List<String>, SlabfishType> entries : NAMES.entrySet()) {
                if (!entries.getKey().contains(name.getString().toLowerCase().trim())) continue;
                if (this.getSlabfishType() == entries.getValue()) {
                    return;
                }
                if (!NAMES.containsValue((Object)this.getSlabfishType())) {
                    this.setPreNameType(this.getSlabfishType());
                }
                this.setSlabfishType(entries.getValue());
                return;
            }
            if (this.getSlabfishType() != this.getPreNameType()) {
                this.setSlabfishType(this.getPreNameType());
            }
        }
    }

    public void playTransformSound() {
        this.func_184185_a((SoundEvent)SwampExSounds.ENTITY_SLABFISH_TRANSFORM.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        this.particleCloud((IParticleData)ParticleTypes.field_218417_ae);
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        UUID uuid = lightningBolt.func_110124_au();
        if (!uuid.equals(this.lightningUUID) && this.getSlabfishType() != SlabfishType.GHOST) {
            if (this.getSlabfishType() == SlabfishType.MUSHROOM) {
                this.setSlabfishType(SlabfishType.BROWN_MUSHROOM);
                this.setPreNameType(SlabfishType.BROWN_MUSHROOM);
            } else if (this.getSlabfishType() == SlabfishType.BROWN_MUSHROOM) {
                this.setSlabfishType(SlabfishType.MUSHROOM);
                this.setPreNameType(SlabfishType.MUSHROOM);
            } else {
                this.setSlabfishType(SlabfishType.SKELETON);
                this.setPreNameType(SlabfishType.SKELETON);
            }
            this.lightningUUID = uuid;
            this.func_184185_a(SoundEvents.field_187754_de, 2.0f, 1.0f);
        }
    }

    public SlabfishType getSlabfishType() {
        return SlabfishType.byId((Integer)this.field_70180_af.func_187225_a(SLABFISH_TYPE));
    }

    public void setSlabfishType(SlabfishType typeId) {
        this.field_70180_af.func_187227_b(SLABFISH_TYPE, (Object)typeId.getId());
    }

    public SlabfishType getPreNameType() {
        return SlabfishType.byId((Integer)this.field_70180_af.func_187225_a(PRE_NAME_TYPE));
    }

    public void setPreNameType(SlabfishType typeId) {
        this.field_70180_af.func_187227_b(PRE_NAME_TYPE, (Object)typeId.getId());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        SlabfishType type;
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        SlabfishType slabfishType = type = reason == SpawnReason.BUCKET ? this.getRandomType() : this.getTypeForConditions(worldIn);
        if (dataTag != null && dataTag.func_150297_b("SlabfishType", 3)) {
            if (dataTag.func_74764_b("Health")) {
                this.func_70606_j(dataTag.func_74760_g("Health"));
            }
            if (dataTag.func_74764_b("Age")) {
                this.func_70873_a(dataTag.func_74762_e("Age"));
            }
            this.setSlabfishType(SlabfishType.byId(dataTag.func_74762_e("SlabfishType")));
            if (dataTag.func_74764_b("PreNameType")) {
                this.setPreNameType(SlabfishType.byId(dataTag.func_74762_e("PreNameType")));
            } else {
                this.setPreNameType(SlabfishType.byId(dataTag.func_74762_e("SlabfishType")));
            }
            if (dataTag.func_74764_b("HasBackpack")) {
                this.setBackpacked(dataTag.func_74767_n("HasBackpack"));
            }
            if (dataTag.func_74764_b("BackpackColor")) {
                this.setBackpackColor(DyeColor.func_196056_a((int)dataTag.func_74762_e("BackpackColor")));
            }
            if (dataTag.func_74764_b("HasSweater")) {
                this.setSweatered(dataTag.func_74767_n("HasSweater"));
            }
            if (dataTag.func_74764_b("SweaterColor")) {
                this.setSweaterColor(DyeColor.func_196056_a((int)dataTag.func_74762_e("SweaterColor")));
            }
            if (dataTag.func_74764_b("BackpackItem")) {
                ItemStack backpackItem = ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("BackpackItem"));
                this.setBackpackItem(backpackItem);
            }
            if (this.hasBackpack() && dataTag.func_74764_b("Items")) {
                ListNBT listnbt = dataTag.func_150295_c("Items", 10);
                this.initSlabfishBackpack();
                for (int i = 0; i < listnbt.size(); ++i) {
                    CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                    int j = compoundnbt.func_74771_c("Slot") & 0xFF;
                    if (j >= this.slabfishBackpack.func_70302_i_()) continue;
                    this.slabfishBackpack.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
                }
            }
            return spawnDataIn;
        }
        if (spawnDataIn instanceof SlabfishData) {
            type = ((SlabfishData)spawnDataIn).typeData;
        } else if (!this.isFromBucket()) {
            spawnDataIn = new SlabfishData(type);
        }
        this.setSlabfishType(type);
        this.setPreNameType(type);
        return spawnDataIn;
    }

    public boolean func_213392_I() {
        return this.isFromBucket();
    }

    public boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean value) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)value);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compound = bucket.func_196082_o();
        CompoundNBT itemstackTag = new CompoundNBT();
        compound.func_74776_a("Health", this.func_110143_aJ());
        compound.func_74768_a("Age", this.func_70874_b());
        compound.func_74768_a("SlabfishType", this.getSlabfishType().getId());
        compound.func_74768_a("PreNameType", this.getPreNameType().getId());
        compound.func_74757_a("HasBackpack", this.hasBackpack());
        if (this.hasBackpack()) {
            compound.func_74774_a("BackpackColor", (byte)this.getBackpackColor().func_196059_a());
        }
        this.getBackpackItem().func_77955_b(itemstackTag);
        if (this.hasBackpack()) {
            compound.func_218657_a("BackpackItem", (INBT)itemstackTag);
        }
        compound.func_74757_a("HasSweater", this.hasSweater());
        if (this.hasSweater()) {
            compound.func_74774_a("SweaterColor", (byte)this.getSweaterColor().func_196059_a());
        }
    }

    public SitGoal func_70907_r() {
        return this.field_70911_d;
    }

    public boolean hasBackpack() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BACKPACK);
    }

    public void setBackpacked(boolean hasBackpack) {
        this.field_70180_af.func_187227_b(HAS_BACKPACK, (Object)hasBackpack);
    }

    public DyeColor getBackpackColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(BACKPACK_COLOR)));
    }

    public void setBackpackColor(DyeColor color) {
        this.field_70180_af.func_187227_b(BACKPACK_COLOR, (Object)color.func_196059_a());
    }

    public ItemStack getBackpackItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(BACKPACK_USED);
    }

    public void setBackpackItem(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(BACKPACK_USED, (Object)itemStack);
    }

    public boolean hasSweater() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_SWEATER);
    }

    public void setSweatered(boolean hasSweater) {
        this.field_70180_af.func_187227_b(HAS_SWEATER, (Object)hasSweater);
    }

    public DyeColor getSweaterColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(SWEATER_COLOR)));
    }

    public void setSweaterColor(DyeColor color) {
        this.field_70180_af.func_187227_b(SWEATER_COLOR, (Object)color.func_196059_a());
    }

    public SlabfishOverlay getSlabfishOverlay() {
        return SlabfishOverlay.byId((Integer)this.field_70180_af.func_187225_a(SLABFISH_OVERLAY));
    }

    public void setSlabfishOverlay(SlabfishOverlay typeId) {
        this.field_70180_af.func_187227_b(SLABFISH_OVERLAY, (Object)typeId.getId());
    }

    public void openGUI(PlayerEntity playerEntity) {
        this.playBackpackSound();
        playerEntity.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((p_213701_1_, p_213701_2_, p_213701_3_) -> new ChestContainer(ContainerType.field_221508_b, p_213701_1_, playerEntity.field_71071_by, (IInventory)this.slabfishBackpack, 2), this.func_145748_c_()));
    }

    protected boolean func_175448_a(ItemStack stack) {
        return this.hasBackpack();
    }

    public boolean func_213365_e(ItemStack stack) {
        return this.hasBackpack();
    }

    protected int getInventorySize() {
        return 18;
    }

    public void initSlabfishBackpack() {
        Inventory inventory = this.slabfishBackpack;
        this.slabfishBackpack = new Inventory(this.getInventorySize()){

            public boolean func_70300_a(PlayerEntity player) {
                return SlabfishEntity.this.func_70089_S() && player.func_70068_e((Entity)SlabfishEntity.this) <= 64.0;
            }
        };
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.slabfishBackpack.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.slabfishBackpack.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.slabfishBackpack.func_110134_a((IInventoryChangedListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.slabfishBackpack));
    }

    public List<ItemEntity> getNearbyItems(float multiplier) {
        return this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b((double)(8.0f * multiplier), 4.0, (double)(8.0f * multiplier)));
    }

    public boolean isPlayerNear(float multiplier) {
        return !this.getNearbyItems(multiplier).isEmpty();
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.hasBackpack()) {
            this.dropItem((IItemProvider)this.getBackpackItem().func_77973_b());
            if (this.slabfishBackpack != null) {
                for (int i = 0; i < this.slabfishBackpack.func_70302_i_(); ++i) {
                    ItemStack itemstack = this.slabfishBackpack.func_70301_a(i);
                    if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                    this.func_199701_a_(itemstack);
                }
            }
        }
        if (this.hasSweater()) {
            this.dropItem((IItemProvider)REVERSE_MAP.get(this.getSweaterColor()));
        }
    }

    protected void dropItems() {
        super.func_213337_cE();
        if (this.hasBackpack() && this.slabfishBackpack != null) {
            for (int i = 0; i < this.slabfishBackpack.func_70302_i_(); ++i) {
                ItemStack itemstack = this.slabfishBackpack.func_70301_a(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    protected void dropBackpack() {
        super.func_213337_cE();
        if (this.hasBackpack()) {
            this.dropItem((IItemProvider)this.getBackpackItem().func_77973_b());
            if (this.slabfishBackpack != null) {
                for (int i = 0; i < this.slabfishBackpack.func_70302_i_(); ++i) {
                    ItemStack itemstack = this.slabfishBackpack.func_70301_a(i);
                    if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                    this.func_199701_a_(itemstack);
                }
            }
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Inventory inventory = this.slabfishBackpack;
        if (this.hasBackpack()) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack1 = inventory.func_70301_a(i);
                if (!itemstack1.func_190926_b() && (itemstack1.func_77973_b() != itemstack.func_77973_b() || itemstack1.func_190916_E() >= itemstack1.func_77976_d() || !ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)itemstack1))) continue;
                inventory.func_174894_a(itemstack);
                this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
                itemEntity.func_70106_y();
                break;
            }
        }
    }

    public void func_76316_a(IInventory invBasic) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData && this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getBucket() {
        return new ItemStack((IItemProvider)SwampExItems.SLABFISH_BUCKET.get());
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{DANCE};
    }

    public Endimation getPlayingEndimation() {
        return this.playingEndimation;
    }

    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    public void setPlayingEndimation(Endimation playingEndimation) {
        this.playingEndimation = playingEndimation;
    }

    public static class SlabfishData
    extends AgeableEntity.AgeableData
    implements ILivingEntityData {
        public final SlabfishType typeData;

        public SlabfishData(SlabfishType type) {
            this.typeData = type;
        }
    }
}

