/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.core.registry;

import com.farcr.swampexpansion.common.world.biome.SwampExBiomeFeatures;
import com.farcr.swampexpansion.common.world.gen.feature.CattailsFeature;
import com.farcr.swampexpansion.common.world.gen.feature.DenseCattailsFeature;
import com.farcr.swampexpansion.common.world.gen.feature.RiceFeature;
import com.farcr.swampexpansion.common.world.gen.feature.WillowTreeFeature;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="swampexpansion", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SwampExFeatures {
    public static final Feature<NoFeatureConfig> CATTAILS = new CattailsFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> DENSE_CATTAILS = new DenseCattailsFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> RICE = new RiceFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<TreeFeatureConfig> WILLOW_TREE = new WillowTreeFeature(TreeFeatureConfig::func_227338_a_);

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{(Feature)CATTAILS.setRegistryName("cattails"), (Feature)DENSE_CATTAILS.setRegistryName("dense_cattails"), (Feature)RICE.setRegistryName("rice"), (Feature)WILLOW_TREE.setRegistryName("willow_tree")});
    }

    public static void generateFeatures() {
        ForgeRegistries.BIOMES.getValues().forEach(SwampExFeatures::generate);
    }

    public static void generate(Biome biome) {
        if (biome == Biomes.field_76780_h || biome == Biomes.field_150599_m) {
            SwampExBiomeFeatures.overrideFeatures(biome);
            SwampExBiomeFeatures.addMushrooms(biome);
            SwampExBiomeFeatures.addWillowTrees(biome);
            SwampExBiomeFeatures.addSwampOaks(biome);
            SwampExBiomeFeatures.addCattails(biome);
            SwampExBiomeFeatures.addDuckweed(biome, 0.15f);
        }
        if (biome.func_150561_m() != Biome.TempCategory.COLD && (biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.RIVER)) {
            SwampExBiomeFeatures.addCattails(biome);
        }
        if (biome.func_201856_r() == Biome.Category.SAVANNA || biome.getRegistryName().toString().contains("rosewood")) {
            SwampExBiomeFeatures.addGiantTallGrass(biome, 3);
        }
        if (biome.func_201856_r() == Biome.Category.JUNGLE) {
            SwampExBiomeFeatures.addGiantTallGrass(biome, 5);
        }
        if (biome.func_201856_r() == Biome.Category.PLAINS) {
            SwampExBiomeFeatures.addGiantTallGrass(biome, 1);
        }
    }
}

