/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.utils.StringUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.Type;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiCommand;
import snownee.kiwi.KiwiConfig;
import snownee.kiwi.KiwiManager;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiObjectHolderRef;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.ModContext;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.Name;
import snownee.kiwi.NoGroup;
import snownee.kiwi.NoItem;
import snownee.kiwi.Skip;
import snownee.kiwi.crafting.FullBlockIngredient;
import snownee.kiwi.crafting.ModuleLoadedCondition;
import snownee.kiwi.schedule.Scheduler;
import snownee.kiwi.util.ReflectionUtil;
import snownee.kiwi.util.Util;

@Mod(value="kiwi")
@Mod.EventBusSubscriber
public class Kiwi {
    public static final String MODID = "kiwi";
    public static final String NAME = "Kiwi";
    public static Logger logger = LogManager.getLogger((String)"Kiwi");
    static final Marker MARKER = MarkerManager.getMarker((String)"Init");
    static Field FIELD_EXTENSION;
    private static Multimap<String, ModFileScanData.AnnotationData> moduleData;
    public static Map<ResourceLocation, Boolean> defaultOptions;
    private static SetMultimap<ResourceLocation, KiwiObjectHolderRef> holderRefs;
    private static Map<ModFileScanData.AnnotationData, String> conditions;
    private static Map<String, ItemGroup> GROUP_CACHE;
    private static MinecraftServer server;

    public Kiwi() {
        Type KIWI_MODULE = Type.getType(KiwiModule.class);
        Type OPTIONAL_MODULE = Type.getType(KiwiModule.Optional.class);
        Type LOADING_CONDITION = Type.getType(KiwiModule.LoadingCondition.class);
        HashMap moduleToOptional = Maps.newHashMap();
        for (ModInfo info : ModList.get().getMods()) {
            ModFileInfo modFileInfo = info.getOwningFile();
            if (modFileInfo == null) continue;
            for (ModFileScanData.AnnotationData annotationData : modFileInfo.getFile().getScanResult().getAnnotations()) {
                if (KIWI_MODULE.equals((Object)annotationData.getAnnotationType())) {
                    String modid = (String)annotationData.getAnnotationData().get("modid");
                    moduleData.put((Object)(Strings.isNullOrEmpty((String)modid) ? info.getModId() : modid), (Object)annotationData);
                    continue;
                }
                if (OPTIONAL_MODULE.equals((Object)annotationData.getAnnotationType())) {
                    moduleToOptional.put(annotationData.getClassType(), annotationData);
                    continue;
                }
                if (!LOADING_CONDITION.equals((Object)annotationData.getAnnotationType())) continue;
                conditions.put(annotationData, info.getModId());
            }
        }
        logger.info(MARKER, "Processing " + moduleData.size() + " KiwiModule annotations");
        for (Map.Entry entry : moduleData.entries()) {
            Boolean disabledByDefault;
            ModFileScanData.AnnotationData optional = (ModFileScanData.AnnotationData)moduleToOptional.get(((ModFileScanData.AnnotationData)entry.getValue()).getClassType());
            if (optional == null) continue;
            String modid = (String)entry.getKey();
            if (!ModList.get().isLoaded(modid)) continue;
            String name = (String)((ModFileScanData.AnnotationData)entry.getValue()).getAnnotationData().get("name");
            if (Strings.isNullOrEmpty((String)name)) {
                name = modid;
            }
            if ((disabledByDefault = (Boolean)optional.getAnnotationData().get("disabledByDefault")) == null) {
                disabledByDefault = Boolean.FALSE;
            }
            defaultOptions.put(new ResourceLocation(modid, name), disabledByDefault);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, KiwiConfig.spec, MODID + (FMLEnvironment.dist.isDedicatedServer() ? "-server.toml" : ".toml"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(EventPriority.LOWEST, this::preInit);
        modEventBus.addListener(this::init);
        modEventBus.addListener(this::clientInit);
        MinecraftForge.EVENT_BUS.addListener(this::serverInit);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, this::serverStopped);
        modEventBus.addListener(this::postInit);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(KiwiManager::handleRegister);
    }

    private void preInit(RegistryEvent.NewRegistry event) {
        Object module;
        try {
            ModContainer myContainer = ModLoadingContext.get().getActiveContainer();
            Field fMap = ModContainer.class.getDeclaredField("configs");
            fMap.setAccessible(true);
            EnumMap map = (EnumMap)fMap.get(myContainer);
            ModConfig config = (ModConfig)map.get(ModConfig.Type.COMMON);
            CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(FMLPaths.CONFIGDIR.get()).apply(config);
            Field fCfg = ModConfig.class.getDeclaredField("configData");
            fCfg.setAccessible(true);
            fCfg.set(config, configData);
            config.getSpec().setConfig((CommentedConfig)configData);
            config.save();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.error(MARKER, "Kiwi failed to load infrastructures. Please report to developer!");
            logger.catching((Throwable)e);
            return;
        }
        HashSet disabledModules = Sets.newHashSet();
        conditions.forEach((k, v) -> {
            try {
                Class<?> clazz = Class.forName(k.getClassType().getClassName());
                int p = k.getMemberName().indexOf(40);
                if (p <= 0) {
                    throw new IllegalArgumentException();
                }
                String methodName = k.getMemberName().substring(0, p);
                List<String> values = (List<String>)k.getAnnotationData().get("value");
                if (values == null) {
                    values = Arrays.asList(v);
                }
                List ids = values.stream().map(s -> Kiwi.checkPrefix(s, v)).collect(Collectors.toList());
                for (ResourceLocation id : ids) {
                    LoadingContext context = new LoadingContext(id);
                    try {
                        Boolean bl = (Boolean)MethodUtils.invokeExactStaticMethod(clazz, (String)methodName, (Object[])new Object[]{context});
                        if (bl.booleanValue()) continue;
                        disabledModules.add(id);
                    }
                    catch (Exception e) {
                        disabledModules.add(id);
                        throw e;
                        return;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error(MARKER, "Failed to access to LoadingCondition: {}", k);
                logger.catching((Throwable)e);
            }
        });
        HashMap infos = Maps.newHashMap();
        boolean checkDep = false;
        block10: for (Map.Entry entry : moduleData.entries()) {
            ResourceLocation rl;
            module = (ModFileScanData.AnnotationData)entry.getValue();
            String string = (String)entry.getKey();
            if (!ModList.get().isLoaded(string)) continue;
            Object name = (String)module.getAnnotationData().get("name");
            if (Strings.isNullOrEmpty((String)name)) {
                name = string;
            }
            if (disabledModules.contains(rl = new ResourceLocation(string, (String)name))) {
                if (KiwiConfig.modules.containsKey(rl)) continue;
                throw new RuntimeException("Cannot load mandatory module: " + rl);
            }
            if (KiwiConfig.modules.containsKey(rl) && !((Boolean)KiwiConfig.modules.get(rl).get()).booleanValue()) continue;
            Info info = new Info(rl, module.getClassType().getClassName());
            String dependencies = (String)module.getAnnotationData().get("dependencies");
            List rules = StringUtils.split((String)Strings.nullToEmpty((String)dependencies), (char)';').stream().filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toList());
            for (String rule : rules) {
                if (rule.startsWith("@")) {
                    info.moduleRules.add(Util.RL(rule.substring(1), string));
                    checkDep = true;
                    continue;
                }
                if (ModList.get().isLoaded(rule)) continue;
                continue block10;
            }
            infos.put(rl, info);
        }
        Object list = null;
        if (checkDep) {
            LinkedList errorList = Lists.newLinkedList();
            block12: for (Info info : infos.values()) {
                for (ResourceLocation id : info.moduleRules) {
                    if (infos.containsKey(id)) continue;
                    errorList.add(info);
                    continue block12;
                }
            }
            module = errorList.iterator();
            while (module.hasNext()) {
                Info info = (Info)module.next();
                IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(info.id.func_110624_b()).get()).getModInfo();
                String dependencies = org.apache.commons.lang3.StringUtils.join(info.moduleRules, (String)", ");
                ModLoader.get().addWarning(new ModLoadingWarning(modInfo, ModLoadingStage.ERROR, "msg.kiwi.no_dependencies", new Object[]{info.id, dependencies}));
            }
            if (!errorList.isEmpty()) {
                return;
            }
            MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(infos.size()).build();
            infos.keySet().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
            infos.values().forEach($ -> $.moduleRules.forEach(r -> graph.putEdge(r, (Object)$.id)));
            list = TopologicalSort.topologicalSort((Graph)graph, null);
        } else {
            list = ImmutableList.copyOf(infos.keySet());
        }
        for (ResourceLocation id : list) {
            Info info = (Info)infos.get(id);
            ModContext context = new ModContext(id.func_110624_b());
            context.setActiveContainer();
            try {
                Class<?> clazz = Class.forName(info.className);
                AbstractModule instance = (AbstractModule)clazz.newInstance();
                KiwiManager.addInstance(id, instance, context);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(MARKER, "Kiwi failed to initialize module class: {}", (Object)info.className);
                logger.catching((Throwable)e);
                continue;
            }
            ModLoadingContext.get().setActiveContainer(null, null);
        }
        moduleData.clear();
        moduleData = null;
        defaultOptions.clear();
        defaultOptions = null;
        conditions.clear();
        conditions = null;
        Util.class.hashCode();
        Object2IntArrayMap counter = new Object2IntArrayMap();
        for (ModuleInfo moduleInfo : KiwiManager.MODULES.values()) {
            String val;
            KiwiModule.Group group;
            boolean useOwnGroup;
            counter.clear();
            moduleInfo.context.setActiveContainer();
            KiwiModule.Subscriber subscriber = moduleInfo.module.getClass().getAnnotation(KiwiModule.Subscriber.class);
            if (subscriber != null && ArrayUtils.contains((Object[])subscriber.side(), (Object)FMLEnvironment.dist)) {
                for (KiwiModule.Subscriber.Bus bus : subscriber.value()) {
                    bus.bus().get().register((Object)moduleInfo.module);
                }
            }
            boolean bl = useOwnGroup = moduleInfo.group == null;
            if (useOwnGroup && (group = moduleInfo.module.getClass().getAnnotation(KiwiModule.Group.class)) != null && !(val = group.value()).isEmpty()) {
                useOwnGroup = false;
                ItemGroup itemGroup = Kiwi.getGroup(val);
                if (itemGroup != null) {
                    moduleInfo.group = itemGroup;
                }
            }
            String modid = moduleInfo.module.uid.func_110624_b();
            String name = moduleInfo.module.uid.func_110623_a();
            Item.Properties tmpBuilder = null;
            Field tmpBuilderField = null;
            for (Field field : moduleInfo.module.getClass().getFields()) {
                int mods;
                if (field.getAnnotation(Skip.class) != null || !Modifier.isPublic(mods = field.getModifiers()) || !Modifier.isStatic(mods)) continue;
                Name nameAnnotation = field.getAnnotation(Name.class);
                ResourceLocation regName = nameAnnotation != null ? Kiwi.checkPrefix(nameAnnotation.value(), modid) : Kiwi.checkPrefix(field.getName().toLowerCase(Locale.ENGLISH), modid);
                if (!Modifier.isFinal(mods)) {
                    if (field.getType() != moduleInfo.module.getClass() || !regName.func_110623_a().equals("instance") || !regName.func_110624_b().equals(modid)) continue;
                    try {
                        field.set(null, moduleInfo.module);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        logger.error(MARKER, "Kiwi failed to inject module instance to module class: {}", (Object)moduleInfo.module.uid);
                        logger.catching((Throwable)e);
                    }
                    continue;
                }
                Object o = null;
                try {
                    o = field.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error(MARKER, "Kiwi failed to catch game object: {}", (Object)field);
                    logger.catching((Throwable)e);
                }
                if (o == null) continue;
                if (useOwnGroup && moduleInfo.group == null && o instanceof ItemGroup) {
                    moduleInfo.group = (ItemGroup)o;
                } else {
                    if (o instanceof IRecipeType) {
                        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)regName, (Object)((IRecipeType)o));
                        tmpBuilder = null;
                        tmpBuilderField = null;
                        continue;
                    }
                    if (o instanceof Item.Properties) {
                        tmpBuilder = (Item.Properties)o;
                        tmpBuilderField = field;
                        continue;
                    }
                    if (o instanceof Block) {
                        if (field.getAnnotation(NoItem.class) != null) {
                            moduleInfo.noItems.add((Block)o);
                        }
                        Kiwi.checkNoGroup(moduleInfo, field, o);
                        if (tmpBuilder != null) {
                            moduleInfo.blockItemBuilders.put((Block)o, tmpBuilder);
                            try {
                                ReflectionUtil.setFinalValue(tmpBuilderField, moduleInfo.module, null);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                                logger.error(MARKER, "Kiwi failed to clean used item builder: {}", (Object)tmpBuilderField);
                                logger.catching((Throwable)e);
                            }
                        }
                    } else if (o instanceof Item) {
                        Kiwi.checkNoGroup(moduleInfo, field, o);
                    }
                }
                if (o instanceof IForgeRegistryEntry) {
                    IForgeRegistryEntry entry = (IForgeRegistryEntry)o;
                    Class superType = entry.getRegistryType();
                    int i = counter.getOrDefault((Object)superType, 0);
                    counter.put((Object)superType, i + 1);
                    moduleInfo.register(entry, regName, field);
                    Optional<KiwiObjectHolderRef> optional = holderRefs.get((Object)regName).stream().filter(ref -> superType.equals(ref.getRegistryType())).findAny();
                    if (optional.isPresent()) {
                        ObjectHolderRegistry.addHandler((Consumer)optional.get().withField(field));
                    }
                }
                tmpBuilder = null;
                tmpBuilderField = null;
            }
            logger.info(MARKER, "Module [{}:{}] initialized", (Object)modid, (Object)name);
            for (Class clazz : counter.keySet()) {
                String k2;
                IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(clazz);
                if (registry != null) {
                    String k3 = Util.trimRL(registry.getRegistryName());
                } else {
                    k2 = "unknown";
                }
                logger.info(MARKER, "    {}: {}", (Object)k2, (Object)counter.getInt((Object)clazz));
            }
        }
        KiwiManager.MODULES.values().forEach(ModuleInfo::preInit);
        ModLoadingContext.get().setActiveContainer(null, null);
        holderRefs.clear();
        holderRefs = null;
    }

    static ItemGroup getGroup(String path) {
        if (GROUP_CACHE == null) {
            return null;
        }
        return GROUP_CACHE.computeIfAbsent(path, $ -> {
            for (ItemGroup group : ItemGroup.field_78032_a) {
                if (!path.equals(group.func_200300_c())) continue;
                return group;
            }
            return null;
        });
    }

    private static void checkNoGroup(ModuleInfo info, Field field, Object o) {
        if (field.getAnnotation(NoGroup.class) != null) {
            info.noGroups.add(o);
        }
    }

    private void init(FMLCommonSetupEvent event) {
        KiwiConfig.refresh();
        CraftingHelper.register((IConditionSerializer)new ModuleLoadedCondition.Serializer());
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "full_block"), (IIngredientSerializer)FullBlockIngredient.SERIALIZER);
        KiwiManager.MODULES.values().forEach(m -> m.init(event));
        ModLoadingContext.get().setActiveContainer(null, null);
    }

    private void clientInit(FMLClientSetupEvent event) {
        KiwiManager.MODULES.values().forEach(m -> m.clientInit(event));
        ModLoadingContext.get().setActiveContainer(null, null);
    }

    private void serverInit(FMLServerStartingEvent event) {
        KiwiCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher(), !event.getServer().func_71262_S());
        KiwiManager.MODULES.values().forEach(m -> m.serverInit(event));
        event.getServer().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(() -> Scheduler.INSTANCE, "kiwi-schedule");
        ModLoadingContext.get().setActiveContainer(null, null);
    }

    public static MinecraftServer getServer() {
        return server;
    }

    private void serverStarting(FMLServerAboutToStartEvent event) {
        server = event.getServer();
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        server = null;
    }

    private void postInit(InterModProcessEvent event) {
        KiwiManager.MODULES.values().forEach(ModuleInfo::postInit);
        ModLoadingContext.get().setActiveContainer(null, null);
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        GROUP_CACHE.clear();
        GROUP_CACHE = null;
    }

    public static boolean isLoaded(ResourceLocation module) {
        return KiwiManager.MODULES.containsKey(module);
    }

    public static boolean isLoaded(AbstractModule module) {
        return KiwiManager.MODULES.values().stream().map($ -> $.module).anyMatch(module::equals);
    }

    public static void applyObjectHolder(IForgeRegistry<?> registry, ResourceLocation registryName) {
        if (holderRefs == null) {
            logger.warn(MARKER, "Adding object holder too late. {}: {}", registry, (Object)registryName);
            return;
        }
        holderRefs.put((Object)registryName, (Object)new KiwiObjectHolderRef(null, registryName, registry));
    }

    private static ResourceLocation checkPrefix(String name, String defaultModid) {
        if (name.contains(":")) {
            return new ResourceLocation(name);
        }
        return new ResourceLocation(defaultModid, name);
    }

    static {
        try {
            FIELD_EXTENSION = ModContainer.class.getDeclaredField("contextExtension");
            FIELD_EXTENSION.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        moduleData = ArrayListMultimap.create();
        defaultOptions = Maps.newHashMap();
        holderRefs = HashMultimap.create();
        conditions = Maps.newHashMap();
        GROUP_CACHE = Maps.newHashMap();
    }

    private static final class Info {
        final ResourceLocation id;
        final String className;
        final List<ResourceLocation> moduleRules = Lists.newLinkedList();

        public Info(ResourceLocation id, String className) {
            this.id = id;
            this.className = className;
        }
    }
}

