/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import snownee.kiwi.KiwiConfig;
import snownee.kiwi.item.ModItem;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class TooltipEvents {
    private static ItemStack lastStack;
    private static CompoundNBT lastNBT;
    private static ITextComponent lastFormatted;
    private static Function<CompoundNBT, ITextComponent> formatter;

    private TooltipEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void globalTooltip(ItemTooltipEvent event) {
        if (KiwiConfig.globalTooltip) {
            ModItem.addTip(event.getItemStack(), event.getToolTip(), event.getFlags());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void debugTooltip(ItemTooltipEvent event) {
        if (!KiwiConfig.debugTooltip || !event.getFlags().func_194127_a()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Minecraft minecraft = Minecraft.func_71410_x();
        if (stack != lastStack && minecraft.field_71439_g != null && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)292)) {
            lastStack = stack;
            CompoundNBT data = stack.func_77978_p();
            StringTextComponent itextcomponent = new StringTextComponent(stack.func_77973_b().getRegistryName().toString());
            if (data != null) {
                itextcomponent.func_150257_a(data.func_197637_c());
            }
            itextcomponent.func_211710_a(arg_0 -> TooltipEvents.lambda$debugTooltip$0((ITextComponent)itextcomponent, arg_0));
            minecraft.field_71439_g.func_145747_a((ITextComponent)itextcomponent);
            minecraft.field_71474_y.field_74330_P = !minecraft.field_71474_y.field_74330_P;
        }
        List tooltip = event.getToolTip();
        if (Screen.hasShiftDown() && stack.func_77942_o()) {
            tooltip.removeIf(c -> c.getClass() == TranslationTextComponent.class && ((TranslationTextComponent)c).func_150268_i().equals("item.nbt_tags"));
            if (lastNBT != stack.func_77978_p()) {
                switch (KiwiConfig.debugTooltipNBTFormatter) {
                    case "kiwi": {
                        formatter = tag -> {
                            TextFormatting[] colors = new TextFormatting[]{TextFormatting.LIGHT_PURPLE, TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.AQUA};
                            String s = tag.toString();
                            StringBuilder sb = new StringBuilder();
                            int i = 0;
                            boolean quoted = false;
                            Iterator iterator = s.chars().boxed().collect(Collectors.toList()).iterator();
                            while (iterator.hasNext()) {
                                int ch = (Integer)iterator.next();
                                boolean special = false;
                                if (quoted) {
                                    if (ch == 34) {
                                        quoted = false;
                                        sb.appendCodePoint(ch);
                                        sb.append(TextFormatting.WHITE);
                                        continue;
                                    }
                                } else {
                                    if (ch == 58 || ch == 44) {
                                        sb.append(TextFormatting.GRAY);
                                        sb.appendCodePoint(ch);
                                        sb.append(TextFormatting.WHITE);
                                        continue;
                                    }
                                    if (ch == 34) {
                                        quoted = true;
                                        sb.append(TextFormatting.GRAY);
                                    } else if (ch == 123 || ch == 91) {
                                        ++i;
                                        special = true;
                                    } else if (ch == 125 || ch == 93) {
                                        special = true;
                                    }
                                }
                                if (special) {
                                    int colotIndex = i % colors.length;
                                    sb.append(colors[colotIndex]);
                                }
                                sb.appendCodePoint(ch);
                                if (!special) continue;
                                sb.append(TextFormatting.WHITE);
                                if (ch != 125 && ch != 93) continue;
                                --i;
                            }
                            return new StringTextComponent(sb.toString());
                        };
                        break;
                    }
                    case "vanilla": {
                        formatter = tag -> stack.func_77978_p().func_197637_c();
                        break;
                    }
                    default: {
                        formatter = tag -> new StringTextComponent(tag.toString());
                    }
                }
                lastNBT = stack.func_77978_p();
                lastFormatted = ((ITextComponent)formatter.apply((Object)lastNBT)).func_211708_a(TextFormatting.RESET);
            }
            tooltip.add(lastFormatted);
        } else {
            stack.func_77973_b().getTags().stream().map(Object::toString).forEach(id -> tooltip.add(new StringTextComponent("#" + id).func_211708_a(TextFormatting.DARK_GRAY)));
        }
    }

    private static /* synthetic */ void lambda$debugTooltip$0(ITextComponent itextcomponent, Style style) {
        style.func_150241_a(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, itextcomponent.getString())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.copy.click", new Object[0]))).func_179989_a(itextcomponent.getString());
    }
}

