/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeRegistryArgument<T extends IForgeRegistryEntry<T>>
implements ArgumentType<T> {
    public static final DynamicCommandExceptionType BAD_ID = new DynamicCommandExceptionType(pair -> new TranslationTextComponent("argument.cuisine.registry.id.invalid", new Object[]{((Pair)pair).getLeft(), ((Pair)pair).getRight()}));
    private final IForgeRegistry<T> registry;
    private Collection<String> examples;

    public ForgeRegistryArgument(IForgeRegistry<T> registry) {
        this.registry = registry;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        ResourceLocation resourcelocation = ResourceLocation.func_195826_a((StringReader)reader);
        if (this.registry.containsKey(resourcelocation)) {
            return (T)this.registry.getValue(resourcelocation);
        }
        reader.setCursor(i);
        throw BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)Pair.of((Object)this.registry.getRegistryName().func_110623_a(), (Object)resourcelocation));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a((Iterable)this.registry.getKeys(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        if (this.examples == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int count = 0;
            for (IForgeRegistryEntry value : this.registry.getValues()) {
                builder.add((Object)value.getRegistryName().toString());
                if (++count != 3) continue;
                break;
            }
            this.examples = builder.build();
        }
        return this.examples;
    }

    public static class Serializer
    implements IArgumentSerializer<ForgeRegistryArgument<? extends IForgeRegistryEntry>> {
        public void write(ForgeRegistryArgument<? extends IForgeRegistryEntry> argument, PacketBuffer buffer) {
            buffer.func_192572_a(((ForgeRegistryArgument)argument).registry.getRegistryName());
        }

        public ForgeRegistryArgument<? extends IForgeRegistryEntry> read(PacketBuffer buffer) {
            return new ForgeRegistryArgument(RegistryManager.ACTIVE.getRegistry(buffer.func_192575_l()));
        }

        public void write(ForgeRegistryArgument<? extends IForgeRegistryEntry> argument, JsonObject json) {
            json.addProperty("registry", ((ForgeRegistryArgument)argument).registry.getRegistryName().toString());
        }
    }
}

