/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.Kiwi;
import snownee.kiwi.contributor.client.RewardLayer;
import snownee.kiwi.contributor.impl.JsonRewardProvider;
import snownee.kiwi.contributor.impl.client.layer.FoxTailLayer;
import snownee.kiwi.contributor.impl.client.layer.PlanetLayer;
import snownee.kiwi.contributor.impl.client.layer.SantaHatLayer;

public class KiwiRewardProvider
extends JsonRewardProvider {
    private final List<String> renderableTiers = ImmutableList.of((Object)"2020q3", (Object)"2020q4");

    public KiwiRewardProvider() {
        super("Snownee", () -> KiwiRewardProvider.getURLs());
    }

    private static List<String> getURLs() {
        String cdn = "https://cdn.jsdelivr.net/gh/Snownee/Kiwi@master/contributors.json";
        String github = "https://raw.githubusercontent.com/Snownee/Kiwi/master/contributors.json";
        String coding = "https://snownee.coding.net/p/test/d/test/git/raw/master/contributors.json";
        Locale locale = Locale.getDefault();
        if (locale.getCountry().equals("CN") && Calendar.getInstance().get(15) == 28800000) {
            Kiwi.logger.debug("Use fetching strategy 1");
            return ImmutableList.of((Object)cdn, (Object)coding);
        }
        Kiwi.logger.debug("Use fetching strategy 2");
        return ImmutableList.of((Object)cdn, (Object)github);
    }

    private static boolean isInXmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 20;
    }

    @Override
    public Set<String> getPlayerTiers(String playerName) {
        HashSet ret = super.getPlayerTiers(playerName);
        if (KiwiRewardProvider.isInXmas()) {
            ret = Sets.newHashSet(ret);
            ret.add("xmas");
        }
        return ret;
    }

    @Override
    public List<String> getRenderableTiers() {
        ArrayList ret = this.renderableTiers;
        if (KiwiRewardProvider.isInXmas()) {
            ret = Lists.newArrayList(ret);
            ret.add("xmas");
        }
        return ret;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RewardLayer createRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRenderer, String tier) {
        switch (tier) {
            case "2020q3": {
                return new PlanetLayer(entityRenderer);
            }
            case "2020q4": {
                return new FoxTailLayer(entityRenderer);
            }
            case "xmas": {
                return new SantaHatLayer(entityRenderer);
            }
        }
        return null;
    }
}

