/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;

public class FullBlockIngredient
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient example;

    protected FullBlockIngredient(Stream<? extends Ingredient.IItemList> itemLists, Ingredient example) {
        super(itemLists);
        this.example = example;
    }

    public static boolean isFullBlock(ItemStack stack) {
        boolean flag;
        if (!FullBlockIngredient.isTextureBlock(stack)) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        BlockState state = block.func_176223_P();
        boolean bl = flag = state.func_200132_m() && !state.func_215691_g();
        if (flag) {
            try {
                if (VoxelShapes.func_197868_b().equals(state.func_196952_d(null, BlockPos.field_177992_a))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isTextureBlock(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        BlockState state = block.func_176223_P();
        return state.func_185904_a().func_76220_a() && state.func_185901_i() == BlockRenderType.MODEL;
    }

    public boolean test(ItemStack stack) {
        return FullBlockIngredient.isFullBlock(stack);
    }

    public Serializer getSerializer() {
        return SERIALIZER;
    }

    public boolean func_203189_d() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public static class Serializer
    implements IIngredientSerializer<FullBlockIngredient> {
        public FullBlockIngredient parse(PacketBuffer buffer) {
            Ingredient example = Ingredient.func_199566_b((PacketBuffer)buffer);
            StackList stackList = new StackList((Collection)ImmutableList.copyOf((Object[])example.func_193365_a()));
            return new FullBlockIngredient(Stream.of(stackList), example);
        }

        public FullBlockIngredient parse(JsonObject json) {
            Ingredient example;
            try {
                example = CraftingHelper.getIngredient((JsonElement)json.get("example"));
            }
            catch (JsonSyntaxException e) {
                example = Ingredient.field_193370_a;
            }
            StackList stackList = new StackList((Collection)ImmutableList.copyOf((Object[])example.func_193365_a()));
            return new FullBlockIngredient(Stream.of(stackList), example);
        }

        public void write(PacketBuffer buffer, FullBlockIngredient ingredient) {
            ingredient.example.func_199564_a(buffer);
        }
    }
}

