/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.schedule.impl;

import com.google.common.base.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import snownee.kiwi.schedule.Task;
import snownee.kiwi.schedule.impl.WorldTicker;
import snownee.kiwi.util.Util;

public class SimpleWorldTask
extends Task<WorldTicker>
implements INBTSerializable<CompoundNBT> {
    protected int tick = 0;
    protected DimensionType dimensionType;
    protected TickEvent.Phase phase;
    protected Function<Integer, Boolean> function;

    public SimpleWorldTask() {
    }

    public SimpleWorldTask(World world, TickEvent.Phase phase, Function<Integer, Boolean> function) {
        this(world.field_73011_w.func_186058_p(), phase, function);
    }

    public SimpleWorldTask(DimensionType dimensionType, TickEvent.Phase phase, Function<Integer, Boolean> function) {
        this.dimensionType = dimensionType;
        this.phase = phase;
        this.function = function;
    }

    @Override
    public boolean tick(WorldTicker ticker) {
        return (Boolean)this.function.apply((Object)(++this.tick));
    }

    @Override
    public WorldTicker ticker() {
        return WorldTicker.get(this.dimensionType, this.phase);
    }

    @Override
    public boolean shouldSave() {
        return this.getClass() != SimpleWorldTask.class;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("tick", this.tick);
        data.func_74778_a("world", Util.trimRL(this.dimensionType.getRegistryName()));
        data.func_74757_a("start", this.phase == TickEvent.Phase.START);
        return data;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ResourceLocation rl = Util.RL(nbt.func_74779_i("world"));
        this.dimensionType = DimensionType.func_193417_a((ResourceLocation)rl);
        if (this.dimensionType == null) {
            throw new NullPointerException("Task cannot find dimension " + rl);
        }
        this.tick = nbt.func_74762_e("tick");
        this.phase = nbt.func_74767_n("start") ? TickEvent.Phase.START : TickEvent.Phase.END;
    }
}

