/*
 * Decompiled with CFR 0.152.
 */
package third_party.com.facebook.yoga;

import java.util.Arrays;
import java.util.Objects;
import third_party.com.facebook.yoga.ArrayUtil;
import third_party.com.facebook.yoga.YogaAlign;
import third_party.com.facebook.yoga.YogaDirection;
import third_party.com.facebook.yoga.YogaDisplay;
import third_party.com.facebook.yoga.YogaFlexDirection;
import third_party.com.facebook.yoga.YogaJustify;
import third_party.com.facebook.yoga.YogaOverflow;
import third_party.com.facebook.yoga.YogaPositionType;
import third_party.com.facebook.yoga.YogaValue;
import third_party.com.facebook.yoga.YogaWrap;

public final class YogaStyle {
    private static final YogaValue[] DefaultEdgeValuesUnit = new YogaValue[]{YogaValue.UNDEFINED, YogaValue.UNDEFINED, YogaValue.UNDEFINED, YogaValue.UNDEFINED, YogaValue.UNDEFINED, YogaValue.UNDEFINED, YogaValue.UNDEFINED, YogaValue.UNDEFINED, YogaValue.UNDEFINED};
    private static final YogaValue[] DefaultDimensionValuesAutoUnit = new YogaValue[]{YogaValue.AUTO, YogaValue.AUTO};
    private static final YogaValue[] DefaultDimensionValuesUnit = new YogaValue[]{YogaValue.UNDEFINED, YogaValue.UNDEFINED};
    public YogaDirection Direction = YogaDirection.Inherit;
    public YogaFlexDirection FlexDirection = YogaFlexDirection.Column;
    public YogaJustify JustifyContent = YogaJustify.FlexStart;
    public YogaAlign AlignContent = YogaAlign.FlexStart;
    public YogaAlign AlignItems = YogaAlign.Stretch;
    public YogaAlign AlignSelf = YogaAlign.Auto;
    public YogaPositionType PositionType = YogaPositionType.Relative;
    public YogaWrap FlexWrap = YogaWrap.NoWrap;
    public YogaOverflow Overflow = YogaOverflow.Visible;
    public YogaDisplay Display = YogaDisplay.Flex;
    public float Flex = Float.NaN;
    public float FlexGrow = Float.NaN;
    public float FlexShrink = Float.NaN;
    public YogaValue FlexBasis = YogaValue.AUTO;
    public YogaValue[] Margin;
    public YogaValue[] Position;
    public YogaValue[] Padding;
    public YogaValue[] Border;
    public YogaValue[] Dimensions;
    public YogaValue[] MinDimensions;
    public YogaValue[] MaxDimensions;
    public float AspectRatio = Float.NaN;

    public YogaStyle() {
        this.Margin = Arrays.copyOf(DefaultEdgeValuesUnit, DefaultEdgeValuesUnit.length);
        this.Position = Arrays.copyOf(DefaultEdgeValuesUnit, DefaultEdgeValuesUnit.length);
        this.Padding = Arrays.copyOf(DefaultEdgeValuesUnit, DefaultEdgeValuesUnit.length);
        this.Border = Arrays.copyOf(DefaultEdgeValuesUnit, DefaultEdgeValuesUnit.length);
        this.Dimensions = Arrays.copyOf(DefaultDimensionValuesAutoUnit, DefaultDimensionValuesAutoUnit.length);
        this.MinDimensions = Arrays.copyOf(DefaultDimensionValuesUnit, DefaultDimensionValuesUnit.length);
        this.MaxDimensions = Arrays.copyOf(DefaultDimensionValuesUnit, DefaultDimensionValuesUnit.length);
    }

    public void CopyFrom(YogaStyle other) {
        this.Direction = other.Direction;
        this.FlexDirection = other.FlexDirection;
        this.JustifyContent = other.JustifyContent;
        this.AlignContent = other.AlignContent;
        this.AlignItems = other.AlignItems;
        this.AlignSelf = other.AlignSelf;
        this.PositionType = other.PositionType;
        this.FlexWrap = other.FlexWrap;
        this.Overflow = other.Overflow;
        this.Display = other.Display;
        this.Flex = other.Flex;
        this.FlexGrow = other.FlexGrow;
        this.FlexShrink = other.FlexShrink;
        this.FlexBasis = other.FlexBasis;
        ArrayUtil.copy(other.Margin, this.Margin);
        ArrayUtil.copy(other.Position, this.Position);
        ArrayUtil.copy(other.Padding, this.Padding);
        ArrayUtil.copy(other.Border, this.Border);
        ArrayUtil.copy(other.Dimensions, this.Dimensions);
        ArrayUtil.copy(other.MinDimensions, this.MinDimensions);
        ArrayUtil.copy(other.MaxDimensions, this.MaxDimensions);
        this.AspectRatio = other.AspectRatio;
    }

    public static boolean Equal(YogaStyle self, YogaStyle style) {
        if (self == style) {
            return true;
        }
        if (self == null || style == null) {
            return false;
        }
        boolean areNonFloatValuesEqual = self.Direction == style.Direction && self.FlexDirection == style.FlexDirection && self.JustifyContent == style.JustifyContent && self.AlignContent == style.AlignContent && self.AlignItems == style.AlignItems && self.AlignSelf == style.AlignSelf && self.PositionType == style.PositionType && self.FlexWrap == style.FlexWrap && self.Overflow == style.Overflow && self.Display == style.Display && Objects.equals(self.FlexBasis, style.FlexBasis) && Arrays.equals(self.Margin, style.Margin) && Arrays.equals(self.Position, style.Position) && Arrays.equals(self.Padding, style.Padding) && Arrays.equals(self.Border, style.Border) && Arrays.equals(self.Dimensions, style.Dimensions) && Arrays.equals(self.MinDimensions, style.MinDimensions) && Arrays.equals(self.MaxDimensions, style.MaxDimensions);
        areNonFloatValuesEqual = areNonFloatValuesEqual && self.Flex == style.Flex;
        areNonFloatValuesEqual = areNonFloatValuesEqual && self.FlexGrow == style.FlexGrow;
        areNonFloatValuesEqual = areNonFloatValuesEqual && self.FlexShrink == style.FlexShrink;
        areNonFloatValuesEqual = areNonFloatValuesEqual && self.AspectRatio == style.AspectRatio;
        return areNonFloatValuesEqual;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != YogaStyle.class) {
            return false;
        }
        return YogaStyle.Equal(this, (YogaStyle)obj);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.Direction, this.FlexDirection, this.JustifyContent, this.AlignContent, this.AlignItems, this.AlignSelf, this.PositionType, this.FlexWrap, this.Overflow, this.Display, Float.valueOf(this.Flex), Float.valueOf(this.FlexGrow), Float.valueOf(this.FlexShrink), this.FlexBasis, this.Margin, this.Position, this.Padding, this.Border, this.Dimensions, this.MinDimensions, this.MaxDimensions, Float.valueOf(this.AspectRatio)});
    }
}

