/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.silentchaos512.lib.network.internal.LeftClickItemPacket;
import net.silentchaos512.lib.network.internal.SilentLibNetwork;

public interface ILeftClickItem {
    default public ActionResult<ItemStack> onItemLeftClickSL(World world, PlayerEntity player, Hand hand) {
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    default public ActionResult<ItemStack> onItemLeftClickBlockSL(World world, PlayerEntity player, Hand hand) {
        return this.onItemLeftClickSL(world, player, hand);
    }

    public static final class EventHandler {
        private static EventHandler INSTANCE;

        private EventHandler() {
        }

        public static void init() {
            if (INSTANCE != null) {
                return;
            }
            INSTANCE = new EventHandler();
            MinecraftForge.EVENT_BUS.addListener(EventHandler::onLeftClickBlock);
            MinecraftForge.EVENT_BUS.addListener(EventHandler::onLeftClickEmpty);
        }

        private static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            ActionResult<ItemStack> result;
            ItemStack stack = event.getItemStack();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ILeftClickItem && (result = ((ILeftClickItem)stack.func_77973_b()).onItemLeftClickBlockSL(event.getWorld(), event.getPlayer(), event.getHand())).func_188397_a() == ActionResultType.SUCCESS) {
                SilentLibNetwork.channel.sendToServer((Object)new LeftClickItemPacket(ClickType.BLOCK, event.getHand()));
            }
        }

        private static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            ActionResult<ItemStack> result;
            ItemStack stack = event.getItemStack();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ILeftClickItem && (result = ((ILeftClickItem)stack.func_77973_b()).onItemLeftClickSL(event.getWorld(), event.getPlayer(), event.getHand())).func_188397_a() == ActionResultType.SUCCESS) {
                SilentLibNetwork.channel.sendToServer((Object)new LeftClickItemPacket(ClickType.EMPTY, event.getHand()));
            }
        }
    }

    public static enum ClickType {
        EMPTY,
        BLOCK;

    }
}

