/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.silentchaos512.lib.network.internal.SilentLibNetwork;
import net.silentchaos512.lib.network.internal.SpawnEntityPacket;

@Mod.EventBusSubscriber(modid="silentlib")
public final class EntityHelper {
    private static volatile Queue<Entity> entitiesToSpawn = new ConcurrentLinkedDeque<Entity>();

    private EntityHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void safeSpawn(Entity entity) {
        entitiesToSpawn.add(entity);
    }

    public static void spawnWithClientPacket(IWorldWriter world, Entity entity) {
        EntityHelper.spawnWithClientPacket(world, entity, 4096.0);
    }

    public static void spawnWithClientPacket(IWorldWriter world, Entity entity, double r2) {
        world.func_217376_c(entity);
        if (world instanceof ServerWorld) {
            SpawnEntityPacket message = new SpawnEntityPacket(entity);
            SilentLibNetwork.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (double)r2, (DimensionType)entity.field_71093_bK)), (Object)message);
        }
    }

    private static void handleSpawns() {
        Entity entity;
        while ((entity = entitiesToSpawn.poll()) != null) {
            entity.field_70170_p.func_217376_c(entity);
        }
    }

    public static void heal(LivingEntity entity, float healAmount, boolean cancelable) {
        if (cancelable) {
            entity.func_70691_i(healAmount);
        } else {
            entity.func_70606_j(entity.func_110143_aJ() + healAmount);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityHelper.handleSpawns();
        }
    }
}

