/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskErrorType;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ErrorCraftingPreviewElement
implements ICraftingPreviewElement<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "error");
    private final CraftingTaskErrorType type;
    private final ItemStack stack;

    public ErrorCraftingPreviewElement(CraftingTaskErrorType type, ItemStack stack) {
        this.type = type;
        this.stack = stack;
    }

    @Override
    public ItemStack getElement() {
        return this.stack;
    }

    @Override
    public void draw(int x, int y, IElementDrawers drawers) {
    }

    @Override
    public int getAvailable() {
        return 0;
    }

    @Override
    public int getToCraft() {
        return 0;
    }

    @Override
    public boolean hasMissing() {
        return false;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeInt(this.type.ordinal());
        buf.func_150788_a(this.stack);
    }

    public CraftingTaskErrorType getType() {
        return this.type;
    }

    public static ErrorCraftingPreviewElement read(PacketBuffer buf) {
        int errorIdx = buf.readInt();
        CraftingTaskErrorType error = errorIdx >= 0 && errorIdx < CraftingTaskErrorType.values().length ? CraftingTaskErrorType.values()[errorIdx] : CraftingTaskErrorType.TOO_COMPLEX;
        ItemStack stack = buf.func_150791_c();
        return new ErrorCraftingPreviewElement(error, stack);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

