/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemCraftingPreviewElement
implements ICraftingPreviewElement<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "item");
    private final ItemStack stack;
    private int available;
    private boolean missing;
    private int toCraft;

    public ItemCraftingPreviewElement(ItemStack stack) {
        this.stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
    }

    public ItemCraftingPreviewElement(ItemStack stack, int available, boolean missing, int toCraft) {
        this.stack = stack;
        this.available = available;
        this.missing = missing;
        this.toCraft = toCraft;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_150788_a(this.stack);
        buf.writeInt(this.available);
        buf.writeBoolean(this.missing);
        buf.writeInt(this.toCraft);
    }

    public static ItemCraftingPreviewElement read(PacketBuffer buf) {
        ItemStack stack = buf.func_150791_c();
        int available = buf.readInt();
        boolean missing = buf.readBoolean();
        int toCraft = buf.readInt();
        return new ItemCraftingPreviewElement(stack, available, missing, toCraft);
    }

    @Override
    public ItemStack getElement() {
        return this.stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        if (this.missing) {
            drawers.getOverlayDrawer().draw(x, y, -860450);
        }
        drawers.getItemDrawer().draw(x += 5, y += 7, this.getElement());
        float scale = Minecraft.func_71410_x().func_211821_e() ? 1.0f : 0.5f;
        y += 2;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        if (this.getToCraft() > 0) {
            String format = this.hasMissing() ? "gui.refinedstorage.crafting_preview.missing" : "gui.refinedstorage.crafting_preview.to_craft";
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 23, scale), RenderUtils.getOffsetOnScale(y, scale), I18n.func_135052_a((String)format, (Object[])new Object[]{this.getToCraft()}));
            y += 7;
        }
        if (this.getAvailable() > 0) {
            drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 23, scale), RenderUtils.getOffsetOnScale(y, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.available", (Object[])new Object[]{this.getAvailable()}));
        }
        RenderSystem.popMatrix();
    }

    public void addAvailable(int amount) {
        this.available += amount;
    }

    @Override
    public int getAvailable() {
        return this.available;
    }

    public void addToCraft(int amount) {
        this.toCraft += amount;
    }

    @Override
    public int getToCraft() {
        return this.toCraft;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    @Override
    public boolean hasMissing() {
        return this.missing;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

