/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.Craft;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.CraftingTask;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.ProcessingState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

class Processing
extends Craft {
    private static final String NBT_ITEMS_TO_RECEIVE = "ItemsToReceive";
    private static final String NBT_FLUIDS_TO_RECEIVE = "FluidsToReceive";
    private static final String NBT_FLUIDS_TO_USE = "FluidsToUse";
    private static final String NBT_STATE = "State";
    private static final String NBT_QUANTITY_TOTAL = "TotalQuantity";
    private static final String NBT_ITEMS_RECEIVED = "ItemsReceived";
    private static final String NBT_FLUIDS_RECEIVED = "FluidsReceived";
    private static final String NBT_ITEMS_TO_DISPLAY = "ItemsToDisplay";
    private IStackList<ItemStack> itemsToReceive = API.instance().createItemStackList();
    private IStackList<ItemStack> itemsReceived = API.instance().createItemStackList();
    private IStackList<FluidStack> fluidsToReceive = API.instance().createFluidStackList();
    private IStackList<FluidStack> fluidsReceived = API.instance().createFluidStackList();
    private IStackList<FluidStack> fluidsToUse = API.instance().createFluidStackList();
    private IStackList<ItemStack> itemsToDisplay;
    private ProcessingState state = ProcessingState.READY;
    private int finished;
    private int totalQuantity;

    Processing(ICraftingPattern pattern, boolean root) {
        super(pattern, root);
    }

    Processing(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        super(network, tag);
        this.itemsToReceive = CraftingTask.readItemStackList(tag.func_150295_c(NBT_ITEMS_TO_RECEIVE, 10));
        this.fluidsToReceive = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_FLUIDS_TO_RECEIVE, 10));
        this.state = ProcessingState.values()[tag.func_74762_e(NBT_STATE)];
        this.totalQuantity = tag.func_74762_e(NBT_QUANTITY_TOTAL);
        this.itemsReceived = CraftingTask.readItemStackList(tag.func_150295_c(NBT_ITEMS_RECEIVED, 10));
        this.fluidsReceived = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_FLUIDS_RECEIVED, 10));
        this.fluidsToUse = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_FLUIDS_TO_USE, 10));
        this.itemsToDisplay = CraftingTask.readItemStackList(tag.func_150295_c(NBT_ITEMS_TO_DISPLAY, 10));
    }

    @Override
    void finishCalculation() {
        this.totalQuantity = this.quantity;
        this.updateItemsToDisplay();
    }

    int getNeeded(ItemStack stack) {
        if (this.itemsToReceive.get(stack) != null) {
            int needed = this.itemsToReceive.get(stack).func_190916_E() * this.totalQuantity;
            if (this.itemsReceived.get(stack) != null) {
                needed -= this.itemsReceived.get(stack).func_190916_E();
            }
            return needed;
        }
        return 0;
    }

    int getNeeded(FluidStack stack) {
        if (this.fluidsToReceive.get(stack) != null) {
            int needed = this.fluidsToReceive.get(stack).getAmount() * this.totalQuantity;
            if (this.fluidsReceived.get(stack) != null) {
                needed -= this.fluidsReceived.get(stack).getAmount();
            }
            return needed;
        }
        return 0;
    }

    boolean updateFinished() {
        int fin = this.finished;
        this.updateFinishedPatterns();
        if (this.finished == this.totalQuantity) {
            this.setState(ProcessingState.PROCESSED);
        }
        return fin != this.finished;
    }

    private void updateFinishedPatterns() {
        int temp = this.totalQuantity;
        if (!this.itemsToReceive.isEmpty()) {
            for (StackListEntry<ItemStack> stackListEntry : this.itemsToReceive.getStacks()) {
                if (this.itemsReceived.get(stackListEntry.getStack()) != null) {
                    if (temp <= this.itemsReceived.get(stackListEntry.getStack()).func_190916_E() / this.itemsToReceive.get(stackListEntry.getStack()).func_190916_E()) continue;
                    temp = this.itemsReceived.get(stackListEntry.getStack()).func_190916_E() / this.itemsToReceive.get(stackListEntry.getStack()).func_190916_E();
                    continue;
                }
                temp = 0;
            }
        }
        if (!this.fluidsToReceive.isEmpty()) {
            for (StackListEntry<ItemStack> stackListEntry : this.fluidsToReceive.getStacks()) {
                if (this.fluidsReceived.get((FluidStack)stackListEntry.getStack()) != null) {
                    if (temp <= this.fluidsReceived.get((FluidStack)stackListEntry.getStack()).getAmount() / this.fluidsToReceive.get((FluidStack)stackListEntry.getStack()).getAmount()) continue;
                    temp = this.fluidsReceived.get((FluidStack)stackListEntry.getStack()).getAmount() / this.fluidsToReceive.get((FluidStack)stackListEntry.getStack()).getAmount();
                    continue;
                }
                temp = 0;
            }
        }
        this.finished = temp;
    }

    IStackList<ItemStack> getItemsToReceive() {
        return this.itemsToReceive;
    }

    IStackList<FluidStack> getFluidsToReceive() {
        return this.fluidsToReceive;
    }

    IStackList<ItemStack> getItemsToDisplay() {
        return this.itemsToDisplay;
    }

    private void updateItemsToDisplay() {
        this.itemsToDisplay = this.getItemsToUse(true);
    }

    IStackList<FluidStack> getFluidsToUse() {
        return this.fluidsToUse;
    }

    void addFluidsToUse(FluidStack stack) {
        this.fluidsToUse.add(stack);
    }

    void addItemsToReceive(ItemStack stack) {
        this.itemsToReceive.add(stack);
    }

    void addFluidsToReceive(FluidStack stack) {
        this.fluidsToReceive.add(stack);
    }

    int getProcessing() {
        return this.totalQuantity - this.quantity - this.finished;
    }

    void addFinished(ItemStack received, int size) {
        this.itemsReceived.add(received, size);
    }

    void addFinished(FluidStack received, int size) {
        this.fluidsReceived.add(received, size);
    }

    void setState(ProcessingState state) {
        this.state = state;
    }

    ProcessingState getState() {
        return this.state;
    }

    boolean hasFluids() {
        return !this.fluidsToUse.isEmpty();
    }

    @Override
    CompoundNBT writeToNbt() {
        CompoundNBT tag = super.writeToNbt();
        tag.func_218657_a(NBT_ITEMS_TO_RECEIVE, (INBT)CraftingTask.writeItemStackList(this.itemsToReceive));
        tag.func_218657_a(NBT_FLUIDS_TO_RECEIVE, (INBT)CraftingTask.writeFluidStackList(this.fluidsToReceive));
        tag.func_74768_a(NBT_STATE, this.state.ordinal());
        tag.func_74768_a(NBT_QUANTITY_TOTAL, this.totalQuantity);
        tag.func_218657_a(NBT_ITEMS_RECEIVED, (INBT)CraftingTask.writeItemStackList(this.itemsReceived));
        tag.func_218657_a(NBT_FLUIDS_RECEIVED, (INBT)CraftingTask.writeFluidStackList(this.fluidsReceived));
        tag.func_218657_a(NBT_FLUIDS_TO_USE, (INBT)CraftingTask.writeFluidStackList(this.fluidsToUse));
        tag.func_218657_a(NBT_ITEMS_TO_DISPLAY, (INBT)CraftingTask.writeItemStackList(this.itemsToDisplay));
        return tag;
    }
}

