/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NetworkNodeListener {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        if (!e.world.func_201670_d() && e.phase == TickEvent.Phase.END) {
            e.world.func_217381_Z().func_76320_a("network node ticking");
            for (INetworkNode node : API.instance().getNetworkNodeManager((ServerWorld)e.world).all()) {
                node.update();
            }
            e.world.func_217381_Z().func_76319_b();
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent e) {
        if (!e.getWorld().func_201670_d() && e.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)e.getEntity();
            INetworkNode placed = NetworkUtils.getNodeFromTile(e.getWorld().func_175625_s(e.getPos()));
            if (placed != null) {
                this.discoverNode(e.getWorld(), e.getPos());
                placed.setOwner(player.func_146103_bH().getId());
                for (Direction facing : Direction.values()) {
                    INetworkNode node = NetworkUtils.getNodeFromTile(e.getWorld().func_175625_s(e.getBlockSnapshot().getPos().func_177972_a(facing)));
                    if (node == null || node.getNetwork() == null || node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, player)) continue;
                    WorldUtils.sendNoPermissionMessage(player);
                    e.setCanceled(true);
                    return;
                }
            }
        }
    }

    private void discoverNode(IWorld world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            INetworkNode node = NetworkUtils.getNodeFromTile(world.func_175625_s(pos.func_177972_a(facing)));
            if (node == null || node.getNetwork() == null) continue;
            node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().getWorld(), node.getNetwork().getPosition());
            return;
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        INetworkNode node;
        if (!e.getWorld().func_201670_d() && (node = NetworkUtils.getNodeFromTile(e.getWorld().func_175625_s(e.getPos()))) != null && node.getNetwork() != null && !node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, e.getPlayer())) {
            WorldUtils.sendNoPermissionMessage(e.getPlayer());
            e.setCanceled(true);
        }
    }
}

