/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node.diskdrive;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.IStorageProvider;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.diskdrive.FluidDriveWrapperStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.network.node.diskdrive.ItemDriveWrapperStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.FluidStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.ItemStorageCache;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.StorageDiskItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.tile.DiskDriveTile;
import com.refinedmods.refinedstorage.tile.config.IAccessType;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IPrioritizable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.AccessTypeUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiskDriveNetworkNode
extends NetworkNode
implements IStorageProvider,
IComparable,
IWhitelistBlacklist,
IPrioritizable,
IType,
IAccessType,
IStorageDiskContainerContext {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "disk_drive");
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int DISK_STATE_UPDATE_THROTTLE = 30;
    private static final Logger LOGGER = LogManager.getLogger(DiskDriveNetworkNode.class);
    private int ticksSinceBlockUpdateRequested;
    private boolean blockUpdateRequested;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));
    private final IStorageDisk[] itemDisks = new IStorageDisk[8];
    private final IStorageDisk[] fluidDisks = new IStorageDisk[8];
    private final BaseItemHandler disks = new BaseItemHandler(8).addValidator(new StorageDiskItemValidator()).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (!this.world.field_72995_K) {
            StackUtils.createStorages((ServerWorld)this.world, handler.getStackInSlot(slot), slot, this.itemDisks, this.fluidDisks, s -> new ItemDriveWrapperStorageDisk(this, (IStorageDisk<ItemStack>)s), s -> new FluidDriveWrapperStorageDisk(this, (IStorageDisk<FluidStack>)s));
            if (this.network != null) {
                this.network.getItemStorageCache().invalidate(InvalidateCause.DISK_INVENTORY_CHANGED);
                this.network.getFluidStorageCache().invalidate(InvalidateCause.DISK_INVENTORY_CHANGED);
            }
            if (!reading) {
                WorldUtils.updateBlock(this.world, this.pos);
            }
        }
    });
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 1;
    private int mode = 1;
    private int type = 0;

    public DiskDriveNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    public IStorageDisk[] getItemDisks() {
        return this.itemDisks;
    }

    public IStorageDisk[] getFluidDisks() {
        return this.fluidDisks;
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.SERVER_CONFIG.getDiskDrive().getUsage();
        for (IStorageDisk storage : this.itemDisks) {
            if (storage == null) continue;
            usage += RS.SERVER_CONFIG.getDiskDrive().getDiskUsage();
        }
        for (IStorageDisk storage : this.fluidDisks) {
            if (storage == null) continue;
            usage += RS.SERVER_CONFIG.getDiskDrive().getDiskUsage();
        }
        return usage;
    }

    @Override
    public void update() {
        super.update();
        if (this.blockUpdateRequested) {
            ++this.ticksSinceBlockUpdateRequested;
            if (this.ticksSinceBlockUpdateRequested > 30) {
                WorldUtils.updateBlock(this.world, this.pos);
                this.blockUpdateRequested = false;
                this.ticksSinceBlockUpdateRequested = 0;
            }
        } else {
            this.ticksSinceBlockUpdateRequested = 0;
        }
    }

    void requestBlockUpdate() {
        this.blockUpdateRequested = true;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        LOGGER.debug("Connectivity state of disk drive at {} changed to {} due to {}", (Object)this.pos, (Object)state, (Object)cause);
        network.getNodeGraph().runActionWhenPossible(ItemStorageCache.INVALIDATE.apply(InvalidateCause.CONNECTED_STATE_CHANGED));
        network.getNodeGraph().runActionWhenPossible(FluidStorageCache.INVALIDATE.apply(InvalidateCause.CONNECTED_STATE_CHANGED));
        WorldUtils.updateBlock(this.world, this.pos);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        for (IStorageDisk storage : this.itemDisks) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        for (IStorageDisk storage : this.fluidDisks) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.disks, 0, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.disks, 0, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 1, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        StackUtils.readItems(this.itemFilters, 1, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getFluidStorageCache().invalidate(InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
            this.network.getItemStorageCache().invalidate(InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
        }
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
            this.network.getFluidStorageCache().sort();
        }
    }

    public DiskState[] getDiskState() {
        DiskState[] diskStates = new DiskState[8];
        for (int i = 0; i < 8; ++i) {
            DiskState state = DiskState.NONE;
            if (this.itemDisks[i] != null || this.fluidDisks[i] != null) {
                state = !this.canUpdate() ? DiskState.DISCONNECTED : DiskState.get(this.itemDisks[i] != null ? this.itemDisks[i].getStored() : this.fluidDisks[i].getStored(), this.itemDisks[i] != null ? this.itemDisks[i].getCapacity() : this.fluidDisks[i].getCapacity());
            }
            diskStates[i] = state;
        }
        return diskStates;
    }

    public IItemHandler getDisks() {
        return this.disks;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? DiskDriveTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public IItemHandler getDrops() {
        return this.disks;
    }
}

