/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.cache.listener;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import com.refinedmods.refinedstorage.network.grid.GridFluidDeltaMessage;
import com.refinedmods.refinedstorage.network.grid.GridFluidUpdateMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fluids.FluidStack;

public class FluidGridStorageCacheListener
implements IStorageCacheListener<FluidStack> {
    private final ServerPlayerEntity player;
    private final INetwork network;

    public FluidGridStorageCacheListener(ServerPlayerEntity player, INetwork network) {
        this.player = player;
        this.network = network;
    }

    @Override
    public void onAttached() {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridFluidUpdateMessage(this.network, this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)this.player)));
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(StackListResult<FluidStack> delta) {
        ArrayList<StackListResult<FluidStack>> deltas = new ArrayList<StackListResult<FluidStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<FluidStack>>)deltas);
    }

    @Override
    public void onChangedBulk(List<StackListResult<FluidStack>> deltas) {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridFluidDeltaMessage(this.network, deltas));
    }
}

