/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.factory.ItemStorageDiskFactory;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStorageDisk
implements IStorageDisk<ItemStack> {
    public static final String NBT_VERSION = "Version";
    public static final String NBT_CAPACITY = "Capacity";
    public static final String NBT_ITEMS = "Items";
    public static final int VERSION = 1;
    @Nullable
    private final ServerWorld world;
    private final int capacity;
    private final Multimap<Item, ItemStack> stacks = ArrayListMultimap.create();
    @Nullable
    private IStorageDiskListener listener;
    private IStorageDiskContainerContext context;

    public ItemStorageDisk(@Nullable ServerWorld world, int capacity) {
        this.world = world;
        this.capacity = capacity;
    }

    @Override
    public CompoundNBT writeToNbt() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (ItemStack stack : this.stacks.values()) {
            list.add((Object)StackUtils.serializeStackToNbt(stack));
        }
        tag.func_74768_a(NBT_VERSION, 1);
        tag.func_218657_a(NBT_ITEMS, (INBT)list);
        tag.func_74768_a(NBT_CAPACITY, this.capacity);
        return tag;
    }

    @Override
    public ResourceLocation getFactoryId() {
        return ItemStorageDiskFactory.ID;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        if (stack.func_190926_b()) {
            return stack;
        }
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                if (action == Action.PERFORM) {
                    otherStack.func_190917_f(remainingSpace);
                    this.onChanged();
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)(size - remainingSpace));
            }
            if (action == Action.PERFORM) {
                otherStack.func_190917_f(size);
                this.onChanged();
            }
            return ItemStack.field_190927_a;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            if (action == Action.PERFORM) {
                this.stacks.put((Object)stack.func_77973_b(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remainingSpace));
                this.onChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
        }
        if (action == Action.PERFORM) {
            this.stacks.put((Object)stack.func_77973_b(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
            this.onChanged();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        if (stack.func_190926_b()) {
            return stack;
        }
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.func_190916_E()) {
                size = otherStack.func_190916_E();
            }
            if (action == Action.PERFORM) {
                if (otherStack.func_190916_E() - size == 0) {
                    this.stacks.remove((Object)otherStack.func_77973_b(), (Object)otherStack);
                } else {
                    otherStack.func_190918_g(size);
                }
                this.onChanged();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)size);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getStored() {
        return this.stacks.values().stream().mapToInt(ItemStack::func_190916_E).sum();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.listener = listener;
        this.context = context;
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.func_190916_E();
    }

    public Multimap<Item, ItemStack> getRawStacks() {
        return this.stacks;
    }

    private void onChanged() {
        if (this.listener != null) {
            this.listener.onChanged();
        }
        if (this.world != null) {
            API.instance().getStorageDiskManager(this.world).markForSaving();
        }
    }
}

