/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.util.DirectionUtils;
import java.util.Arrays;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.DirectionProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public enum BlockDirection {
    NONE(new Direction[0]),
    ANY(Direction.values()),
    ANY_FACE_PLAYER(Direction.values()),
    HORIZONTAL(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);

    private final DirectionProperty property;

    private BlockDirection(Direction ... allowed) {
        this.property = DirectionProperty.func_177713_a((String)"direction", Arrays.asList(allowed));
    }

    public DirectionProperty getProperty() {
        return this.property;
    }

    public Direction getFrom(Direction facing, BlockPos pos, LivingEntity entity) {
        switch (this) {
            case ANY: {
                return facing.func_176734_d();
            }
            case ANY_FACE_PLAYER: {
                return DirectionUtils.getFacingFromEntity(pos, entity);
            }
            case HORIZONTAL: {
                return entity.func_174811_aO().func_176734_d();
            }
        }
        throw new RuntimeException("Unknown direction type");
    }

    public Direction cycle(Direction previous) {
        switch (this) {
            case ANY: 
            case ANY_FACE_PLAYER: {
                return previous.ordinal() + 1 >= Direction.values().length ? Direction.values()[0] : Direction.values()[previous.ordinal() + 1];
            }
            case HORIZONTAL: {
                return previous.func_176735_f();
            }
        }
        throw new RuntimeException("Unknown direction type");
    }
}

