/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.container.FluidStorageContainer;
import com.refinedmods.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.refinedmods.refinedstorage.tile.FluidStorageTile;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluidStorageBlock
extends NetworkNodeBlock {
    private final FluidStorageType type;

    public FluidStorageBlock(FluidStorageType type) {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.type = type;
        this.setRegistryName("refinedstorage", type.getName() + "_fluid_storage_block");
    }

    public FluidStorageType getType() {
        return this.type;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        if (!world.field_72995_K) {
            FluidStorageNetworkNode storage = (FluidStorageNetworkNode)((FluidStorageTile)world.func_175625_s(pos)).getNode();
            if (stack.func_77942_o() && stack.func_77978_p().func_186855_b("Id")) {
                storage.setStorageId(stack.func_77978_p().func_186857_a("Id"));
            }
            storage.loadStorage();
        }
        super.func_180633_a(world, pos, state, player, stack);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FluidStorageTile(this.type);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            return NetworkUtils.attemptModify(world, pos, hit.func_216354_b(), player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), new PositionalTileContainerProvider<FluidStorageTile>(((FluidStorageNetworkNode)((FluidStorageTile)world.func_175625_s(pos)).getNode()).getTitle(), (tile, windowId, inventory, p) -> new FluidStorageContainer((FluidStorageTile)tile, player, windowId), pos), (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }
}

