/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.render.Styles;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class PatternDumpCommand
implements Command<CommandSource> {
    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"patterndump").requires(cs -> cs.func_197034_c(0))).executes((Command)new PatternDumpCommand());
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ItemStack stack = ((CommandSource)context.getSource()).func_197035_h().field_71071_by.func_70448_g();
        if (stack.func_77973_b() instanceof PatternItem) {
            boolean processing = PatternItem.isProcessing(stack);
            boolean exact = PatternItem.isExact(stack);
            AllowedTagList allowedTagList = PatternItem.getAllowedTags(stack);
            CraftingPattern pattern = PatternItem.fromCache((World)((CommandSource)context.getSource()).func_197023_e(), stack);
            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Crafting task factory ID: ").func_150255_a(Styles.YELLOW).func_150257_a(new StringTextComponent(pattern.getCraftingTaskFactoryId().toString()).func_150255_a(Styles.WHITE)), false);
            if (!pattern.isValid()) {
                ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Pattern is invalid! Reason: ").func_150257_a(pattern.getErrorMessage()).func_150255_a(Styles.RED), false);
            } else {
                ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Processing: ").func_150255_a(Styles.YELLOW).func_150257_a(new StringTextComponent(String.valueOf(processing)).func_150255_a(Styles.WHITE)), false);
                ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Exact: ").func_150255_a(Styles.YELLOW).func_150257_a(new StringTextComponent(String.valueOf(exact)).func_150255_a(Styles.WHITE)), false);
                ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Has allowed tag list: ").func_150255_a(Styles.YELLOW).func_150257_a(new StringTextComponent(String.valueOf(allowedTagList != null)).func_150255_a(Styles.WHITE)), false);
                if (pattern.isProcessing()) {
                    int i;
                    for (i = 0; i < pattern.getInputs().size(); ++i) {
                        if (!pattern.getInputs().get(i).isEmpty()) {
                            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Item inputs in slot " + i + ":").func_150255_a(Styles.YELLOW), false);
                            for (int j = 0; j < pattern.getInputs().get(i).size(); ++j) {
                                ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("- Possibility #" + j + ": " + ((ItemStack)pattern.getInputs().get(i).get(j)).func_190916_E() + "x ").func_150257_a(((ItemStack)pattern.getInputs().get(i).get(j)).func_200301_q()), false);
                            }
                        }
                        if (allowedTagList == null) continue;
                        for (ResourceLocation allowed : allowedTagList.getAllowedItemTags().get(i)) {
                            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("- Allowed item tag: " + allowed.toString()), false);
                        }
                    }
                    for (i = 0; i < pattern.getFluidInputs().size(); ++i) {
                        if (!pattern.getFluidInputs().get(i).isEmpty()) {
                            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Fluid inputs in slot " + i + ":").func_150255_a(Styles.YELLOW), false);
                            for (int j = 0; j < pattern.getFluidInputs().get(i).size(); ++j) {
                                ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("- Possibility #" + j + ": " + ((FluidStack)pattern.getFluidInputs().get(i).get(j)).getAmount() + " mB ").func_150257_a(((FluidStack)pattern.getFluidInputs().get(i).get(j)).getDisplayName()), false);
                            }
                        }
                        if (allowedTagList == null) continue;
                        for (ResourceLocation allowed : allowedTagList.getAllowedFluidTags().get(i)) {
                            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("- Allowed fluid tag: " + allowed.toString()), false);
                        }
                    }
                    ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Outputs").func_150255_a(Styles.YELLOW), false);
                    for (ItemStack output : pattern.getOutputs()) {
                        ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("- " + output.func_190916_E() + "x ").func_150257_a(output.func_200301_q()), false);
                    }
                    ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Fluid outputs").func_150255_a(Styles.YELLOW), false);
                    for (FluidStack output : pattern.getFluidOutputs()) {
                        ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("- " + output.getAmount() + " mB ").func_150257_a(output.getDisplayName()), false);
                    }
                } else {
                    for (int i = 0; i < pattern.getInputs().size(); ++i) {
                        if (pattern.getInputs().get(i).isEmpty()) continue;
                        ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Inputs in slot " + i + ":").func_150255_a(Styles.YELLOW), false);
                        for (int j = 0; j < pattern.getInputs().get(i).size(); ++j) {
                            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("- Possibility #" + j + ": " + ((ItemStack)pattern.getInputs().get(i).get(j)).func_190916_E() + "x ").func_150257_a(((ItemStack)pattern.getInputs().get(i).get(j)).func_200301_q()), false);
                        }
                    }
                    ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Outputs").func_150255_a(Styles.YELLOW), false);
                    for (ItemStack output : pattern.getOutputs()) {
                        ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("- " + output.func_190916_E() + "x ").func_150257_a(output.func_200301_q()), false);
                    }
                    boolean anyByproducts = false;
                    for (ItemStack byproduct : pattern.getByproducts()) {
                        if (byproduct.func_190926_b()) continue;
                        if (!anyByproducts) {
                            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("Byproducts").func_150255_a(Styles.YELLOW), false);
                            anyByproducts = true;
                        }
                        ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("- " + byproduct.func_190916_E() + "x ").func_150257_a(byproduct.func_200301_q()), false);
                    }
                }
            }
        } else {
            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("You need to be holding a pattern in your hand.").func_150255_a(Styles.RED), false);
        }
        return 0;
    }
}

