/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.item.capabilityprovider.EnergyCapabilityProvider;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyItem
extends Item {
    private final Supplier<Integer> energyCapacity;
    private final boolean creative;

    public EnergyItem(Item.Properties properties, boolean creative, Supplier<Integer> energyCapacity) {
        super(properties);
        this.creative = creative;
        this.energyCapacity = energyCapacity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT tag) {
        return new EnergyCapabilityProvider(stack, this.energyCapacity.get());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.creative;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (energy == null) {
            return 0.0;
        }
        return 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (energy == null) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (!this.creative) {
            stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(energy -> tooltip.add(new TranslationTextComponent("misc.refinedstorage.energy_stored", new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}).func_150255_a(Styles.GRAY)));
        }
    }
}

