/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.apiimpl.network.item.WirelessCraftingMonitorNetworkItem;
import com.refinedmods.refinedstorage.item.NetworkItem;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class WirelessCraftingMonitorItem
extends NetworkItem {
    public static final String NBT_TAB_SELECTED = "TabSelected";
    public static final String NBT_TAB_PAGE = "TabPage";
    private final Type type;

    public WirelessCraftingMonitorItem(Type type) {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP).func_200917_a(1), type == Type.CREATIVE, () -> RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCapacity());
        this.setRegistryName("refinedstorage", (type == Type.CREATIVE ? "creative_" : "") + "wireless_crafting_monitor");
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public INetworkItem provide(INetworkItemManager handler, PlayerEntity player, ItemStack stack, int slotId) {
        return new WirelessCraftingMonitorNetworkItem(handler, player, stack, slotId);
    }

    public static Optional<UUID> getTabSelected(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(NBT_TAB_SELECTED)) {
            return Optional.of(stack.func_77978_p().func_186857_a(NBT_TAB_SELECTED));
        }
        return Optional.empty();
    }

    public static void setTabSelected(ItemStack stack, Optional<UUID> tabSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (tabSelected.isPresent()) {
            stack.func_77978_p().func_186854_a(NBT_TAB_SELECTED, tabSelected.get());
        } else {
            stack.func_77978_p().func_82580_o("TabSelectedLeast");
            stack.func_77978_p().func_82580_o("TabSelectedMost");
        }
    }

    public static int getTabPage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_TAB_PAGE)) {
            return stack.func_77978_p().func_74762_e(NBT_TAB_PAGE);
        }
        return 0;
    }

    public static void setTabPage(ItemStack stack, int tabPage) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a(NBT_TAB_PAGE, tabPage);
    }

    public static enum Type {
        NORMAL,
        CREATIVE;

    }
}

