/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.view.ItemGridView;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridItemUpdateMessage {
    private INetwork network;
    private final boolean canCraft;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();

    public GridItemUpdateMessage(boolean canCraft, List<IGridStack> stacks) {
        this.canCraft = canCraft;
        this.stacks = stacks;
    }

    public GridItemUpdateMessage(INetwork network, boolean canCraft) {
        this.network = network;
        this.canCraft = canCraft;
    }

    public static GridItemUpdateMessage decode(PacketBuffer buf) {
        boolean canCraft = buf.readBoolean();
        int size = buf.readInt();
        ArrayList<IGridStack> stacks = new ArrayList<IGridStack>();
        for (int i = 0; i < size; ++i) {
            stacks.add(StackUtils.readItemGridStack(buf));
        }
        return new GridItemUpdateMessage(canCraft, stacks);
    }

    public static void encode(GridItemUpdateMessage message, PacketBuffer buf) {
        buf.writeBoolean(message.canCraft);
        int size = message.network.getItemStorageCache().getList().getStacks().size() + message.network.getItemStorageCache().getCraftablesList().getStacks().size();
        buf.writeInt(size);
        for (StackListEntry<ItemStack> stack : message.network.getItemStorageCache().getList().getStacks()) {
            StackListEntry<ItemStack> craftingEntry = message.network.getItemStorageCache().getCraftablesList().getEntry(stack.getStack(), 1);
            StackUtils.writeItemGridStack(buf, stack.getStack(), stack.getId(), craftingEntry != null ? craftingEntry.getId() : null, false, message.network.getItemStorageTracker().get(stack.getStack()));
        }
        for (StackListEntry<ItemStack> stack : message.network.getItemStorageCache().getCraftablesList().getStacks()) {
            StackListEntry<ItemStack> regularEntry = message.network.getItemStorageCache().getList().getEntry(stack.getStack(), 1);
            StackUtils.writeItemGridStack(buf, stack.getStack(), stack.getId(), regularEntry != null ? regularEntry.getId() : null, true, message.network.getItemStorageTracker().get(stack.getStack()));
        }
    }

    public static void handle(GridItemUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        BaseScreen.executeLater(GridScreen.class, grid -> {
            grid.setView(new ItemGridView((GridScreen)grid, GridScreen.getDefaultSorter(), GridScreen.getSorters()));
            grid.getView().setCanCraft(message.canCraft);
            grid.getView().setStacks(message.stacks);
            grid.getView().sort();
        });
        ctx.get().setPacketHandled(true);
    }
}

