/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.tiledata;

import com.refinedmods.refinedstorage.container.BaseContainer;
import com.refinedmods.refinedstorage.tile.BaseTile;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class TileDataParameterUpdateMessage {
    private final TileDataParameter parameter;
    private final Object value;

    public TileDataParameterUpdateMessage(TileDataParameter parameter, Object value) {
        this.parameter = parameter;
        this.value = value;
    }

    public static TileDataParameterUpdateMessage decode(PacketBuffer buf) {
        int id = buf.readInt();
        TileDataParameter parameter = TileDataManager.getParameter(id);
        Object value = null;
        if (parameter != null) {
            try {
                value = parameter.getSerializer().func_187159_a(buf);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TileDataParameterUpdateMessage(parameter, value);
    }

    public static void encode(TileDataParameterUpdateMessage message, PacketBuffer buf) {
        buf.writeInt(message.parameter.getId());
        message.parameter.getSerializer().func_187160_a(buf, message.value);
    }

    public static void handle(TileDataParameterUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BiConsumer consumer;
            Container c = ((NetworkEvent.Context)ctx.get()).getSender().field_71070_bA;
            if (c instanceof BaseContainer && (consumer = message.parameter.getValueConsumer()) != null) {
                consumer.accept(((BaseContainer)c).getTile(), (BaseTile)((Object)((Object)message.value)));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

