/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.common.model.TransformationHelper;

public final class QuadTransformer {
    public static List<BakedQuad> getTransformedQuads(IBakedModel model, Direction facing, @Nullable Vector3f translation, BlockState state, Random rand, Direction side) {
        double r = Math.PI * (double)(360 - facing.func_176734_d().func_176736_b() * 90) / 180.0;
        TransformationMatrix transformation = new TransformationMatrix(translation, TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, (float)r, 0.0f), (boolean)false), null, null);
        ImmutableList.Builder quads = ImmutableList.builder();
        if (side != null && side.func_176736_b() > -1) {
            int faceOffset = 4 + Direction.NORTH.func_176736_b() - facing.func_176736_b();
            side = Direction.func_176731_b((int)((side.func_176736_b() + faceOffset) % 4));
        }
        for (BakedQuad quad : model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE)) {
            BakedQuadBuilder builder = new BakedQuadBuilder(quad.func_187508_a());
            TRSRTransformer transformer = new TRSRTransformer((IVertexConsumer)builder, transformation.blockCenterToCorner());
            quad.pipe((IVertexConsumer)transformer);
            quads.add((Object)builder.build());
        }
        return quads.build();
    }
}

