/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.CraftingSettingsContainer;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewRequestMessage;
import com.refinedmods.refinedstorage.screen.AmountSpecifyingScreen;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.FluidGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CraftingSettingsScreen
extends AmountSpecifyingScreen<CraftingSettingsContainer> {
    private final IGridStack stack;

    public CraftingSettingsScreen(BaseScreen parent, PlayerEntity player, IGridStack stack) {
        super(parent, new CraftingSettingsContainer(player, stack), 172, 99, player.field_71071_by, (ITextComponent)new TranslationTextComponent("container.crafting", new Object[0]));
        this.stack = stack;
    }

    @Override
    protected String getOkButtonText() {
        return I18n.func_135052_a((String)"misc.refinedstorage.start", (Object[])new Object[0]);
    }

    @Override
    protected String getTexture() {
        return "gui/amount_specifying.png";
    }

    @Override
    protected int[] getIncrements() {
        if (this.stack instanceof FluidGridStack) {
            return new int[]{100, 500, 1000, -100, -500, -1000};
        }
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack instanceof FluidGridStack ? 1000 : 1;
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int quantity = Integer.parseInt(this.amountField.func_146179_b());
            RS.NETWORK_HANDLER.sendToServer(new GridCraftingPreviewRequestMessage(this.stack.getId(), quantity, shiftDown, this.stack instanceof FluidGridStack));
            this.okButton.active = false;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

