/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile.grid;

import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.data.RSSerializers;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import com.refinedmods.refinedstorage.util.GridUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class GridTile
extends NetworkNodeTile<GridNetworkNode> {
    public static final TileDataParameter<Integer, GridTile> VIEW_TYPE = new TileDataParameter<Integer, GridTile>(DataSerializers.field_187192_b, 0, t -> ((GridNetworkNode)t.getNode()).getViewType(), (t, v) -> {
        if (IGrid.isValidViewType(v)) {
            ((GridNetworkNode)t.getNode()).setViewType((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> GridTile.trySortGrid(initial));
    public static final TileDataParameter<Integer, GridTile> SORTING_DIRECTION = new TileDataParameter<Integer, GridTile>(DataSerializers.field_187192_b, 0, t -> ((GridNetworkNode)t.getNode()).getSortingDirection(), (t, v) -> {
        if (IGrid.isValidSortingDirection(v)) {
            ((GridNetworkNode)t.getNode()).setSortingDirection((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> GridTile.trySortGrid(initial));
    public static final TileDataParameter<Integer, GridTile> SORTING_TYPE = new TileDataParameter<Integer, GridTile>(DataSerializers.field_187192_b, 0, t -> ((GridNetworkNode)t.getNode()).getSortingType(), (t, v) -> {
        if (IGrid.isValidSortingType(v)) {
            ((GridNetworkNode)t.getNode()).setSortingType((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> GridTile.trySortGrid(initial));
    public static final TileDataParameter<Integer, GridTile> SEARCH_BOX_MODE = new TileDataParameter<Integer, GridTile>(DataSerializers.field_187192_b, 0, t -> ((GridNetworkNode)t.getNode()).getSearchBoxMode(), (t, v) -> {
        if (IGrid.isValidSearchBoxMode(v)) {
            ((GridNetworkNode)t.getNode()).setSearchBoxMode((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getSearchField().setMode((int)p)));
    public static final TileDataParameter<Integer, GridTile> SIZE = new TileDataParameter<Integer, GridTile>(DataSerializers.field_187192_b, 0, t -> ((GridNetworkNode)t.getNode()).getSize(), (t, v) -> {
        if (IGrid.isValidSize(v)) {
            ((GridNetworkNode)t.getNode()).setSize((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, BaseScreen::init));
    public static final TileDataParameter<Integer, GridTile> TAB_SELECTED = new TileDataParameter<Integer, GridTile>(DataSerializers.field_187192_b, 0, t -> ((GridNetworkNode)t.getNode()).getTabSelected(), (t, v) -> {
        ((GridNetworkNode)t.getNode()).setTabSelected(v.intValue() == ((GridNetworkNode)t.getNode()).getTabSelected() ? -1 : v);
        ((GridNetworkNode)t.getNode()).markDirty();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort()));
    public static final TileDataParameter<Integer, GridTile> TAB_PAGE = new TileDataParameter<Integer, GridTile>(DataSerializers.field_187192_b, 0, t -> ((GridNetworkNode)t.getNode()).getTabPage(), (t, v) -> {
        if (v >= 0 && v <= ((GridNetworkNode)t.getNode()).getTotalTabPages()) {
            ((GridNetworkNode)t.getNode()).setTabPage((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    });
    public static final TileDataParameter<Boolean, GridTile> EXACT_PATTERN = new TileDataParameter<Boolean, GridTile>(DataSerializers.field_187198_h, true, t -> ((GridNetworkNode)t.getNode()).isExactPattern(), (t, v) -> {
        ((GridNetworkNode)t.getNode()).setExactPattern((boolean)v);
        ((GridNetworkNode)t.getNode()).markDirty();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.updateExactPattern((boolean)p)));
    public static final TileDataParameter<Boolean, GridTile> PROCESSING_PATTERN = new TileDataParameter<Boolean, GridTile>(DataSerializers.field_187198_h, false, t -> ((GridNetworkNode)t.getNode()).isProcessingPattern(), (t, v) -> {
        ((GridNetworkNode)t.getNode()).setProcessingPattern((boolean)v);
        ((GridNetworkNode)t.getNode()).clearMatrix();
        ((GridNetworkNode)t.getNode()).markDirty();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, BaseScreen::init));
    public static final TileDataParameter<Integer, GridTile> PROCESSING_TYPE = IType.createParameter((initial, p) -> BaseScreen.executeLater(GridScreen.class, BaseScreen::init));
    public static final TileDataParameter<List<Set<ResourceLocation>>, GridTile> ALLOWED_ITEM_TAGS = new TileDataParameter<List, GridTile>(RSSerializers.LIST_OF_SET_SERIALIZER, new ArrayList(), t -> ((GridNetworkNode)t.getNode()).getAllowedTagList().getAllowedItemTags(), (t, v) -> ((GridNetworkNode)t.getNode()).getAllowedTagList().setAllowedItemTags((List<Set<ResourceLocation>>)v));
    public static final TileDataParameter<List<Set<ResourceLocation>>, GridTile> ALLOWED_FLUID_TAGS = new TileDataParameter<List, GridTile>(RSSerializers.LIST_OF_SET_SERIALIZER, new ArrayList(), t -> ((GridNetworkNode)t.getNode()).getAllowedTagList().getAllowedFluidTags(), (t, v) -> ((GridNetworkNode)t.getNode()).getAllowedTagList().setAllowedFluidTags((List<Set<ResourceLocation>>)v));
    private final GridType type;
    private final LazyOptional<IItemHandler> diskCapability = LazyOptional.of(() -> ((GridNetworkNode)this.getNode()).getPatterns());

    public static void trySortGrid(boolean initial) {
        if (!initial) {
            BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
        }
    }

    public GridTile(GridType type) {
        super(GridUtils.getTileEntityType(type));
        this.type = type;
        this.dataManager.addWatchedParameter(VIEW_TYPE);
        this.dataManager.addWatchedParameter(SORTING_DIRECTION);
        this.dataManager.addWatchedParameter(SORTING_TYPE);
        this.dataManager.addWatchedParameter(SEARCH_BOX_MODE);
        this.dataManager.addWatchedParameter(SIZE);
        this.dataManager.addWatchedParameter(TAB_SELECTED);
        this.dataManager.addWatchedParameter(TAB_PAGE);
        this.dataManager.addWatchedParameter(EXACT_PATTERN);
        this.dataManager.addWatchedParameter(PROCESSING_PATTERN);
        this.dataManager.addWatchedParameter(PROCESSING_TYPE);
        this.dataManager.addParameter(ALLOWED_ITEM_TAGS);
        this.dataManager.addParameter(ALLOWED_FLUID_TAGS);
    }

    @Override
    @Nonnull
    public GridNetworkNode createNode(World world, BlockPos pos) {
        return new GridNetworkNode(world, pos, this.type);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.type == GridType.PATTERN) {
            return this.diskCapability.cast();
        }
        return super.getCapability(cap, direction);
    }
}

