/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mushroom.midnight.client.MidnightKeybinds;
import com.mushroom.midnight.client.gui.config.MidnightConfigGUIFactory;
import com.mushroom.midnight.client.render.block.BlockRenderLayer;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.config.provider.IConfigProvider;
import com.mushroom.midnight.common.recipe.MidnightRecipeBookCategories;
import com.mushroom.midnight.common.util.IProxy;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="midnight", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy
implements IProxy {
    private static final Minecraft MC = Minecraft.func_71410_x();
    public static boolean enqueuedServerConfigUpdate;
    public static IConfigProvider worldSetupConfig;

    @Override
    public void onConstruct() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, MidnightConfigGUIFactory::new);
    }

    @Override
    public boolean isClientPlayer(Entity entity) {
        return entity == ClientProxy.MC.field_71439_g;
    }

    public static void setup(FMLCommonSetupEvent event) {
        BlockRenderLayer.renderBlock();
        MidnightRecipeBookCategories.justLoadClass();
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        MidnightKeybinds.registerKeybinds();
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            event.addSprite(new ResourceLocation("midnight", "entities/chest/shadowroot_chest_right"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/shadowroot_chest_left"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/shadowroot_chest"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dark_willow_chest_right"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dark_willow_chest_left"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dark_willow_chest"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dead_wood_chest_right"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dead_wood_chest_left"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dead_wood_chest"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/nightshroom_chest_right"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/nightshroom_chest_left"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/nightshroom_chest"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dewshroom_chest_right"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dewshroom_chest_left"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/dewshroom_chest"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/viridshroom_chest_right"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/viridshroom_chest_left"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/viridshroom_chest"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/bogshroom_chest_right"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/bogshroom_chest_left"));
            event.addSprite(new ResourceLocation("midnight", "entities/chest/bogshroom_chest"));
        }
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.Loading event) {
        File file;
        MinecraftServer server;
        if (event.getConfig().getType() == ModConfig.Type.SERVER && (server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)) instanceof IntegratedServer && !(file = server.func_71254_M().func_186352_b(server.func_71270_I(), "midnight_configured.txt")).exists() && worldSetupConfig != null) {
            MidnightConfig.SERVER_PROFILE.importFromProvider(worldSetupConfig, true);
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
                PrintStream stream = new PrintStream(file);
                stream.println("Midnight configured!");
                stream.println("This file is used by the Midnight mod to ensure that world generator configs aren't overwritten when loading the world.");
                stream.println("DO NOT DELETE THIS FILE, OTHERWISE YOUR WORLD GEN CONFIG WILL RESET UPON WORLD LOAD!!!");
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
        }
    }
}

