/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mushroom.midnight.common.fluid.DarkWaterFluid;
import com.mushroom.midnight.common.fluid.MiasmaFluid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="midnight", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class FluidImmersionRenderer {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static final ResourceLocation DARK_WATER_OVERLAY = new ResourceLocation("midnight", "textures/effects/dark_water_overlay.png");
    public static IFluidState immersedFluid = Fluids.field_204541_a.func_207188_f();

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && FluidImmersionRenderer.CLIENT.field_71439_g != null) {
            ActiveRenderInfo activeRenderInfo = FluidImmersionRenderer.CLIENT.field_71460_t.func_215316_n();
            immersedFluid = activeRenderInfo.func_216771_k();
        }
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (immersedFluid.func_206886_c() instanceof MiasmaFluid) {
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setDensity(2.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSetupFogColor(EntityViewRenderEvent.FogColors event) {
        ActiveRenderInfo activeRenderInfo = FluidImmersionRenderer.CLIENT.field_71460_t.func_215316_n();
        immersedFluid = activeRenderInfo.func_216771_k();
        if (immersedFluid.func_206886_c() instanceof MiasmaFluid) {
            event.setRed(0.6313726f);
            event.setGreen(0.77254903f);
            event.setBlue(0.96862745f);
        }
    }

    @SubscribeEvent
    public static void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        if (immersedFluid.func_206886_c() instanceof DarkWaterFluid) {
            FluidImmersionRenderer.renderOverlay(DARK_WATER_OVERLAY);
            event.setCanceled(true);
        }
    }

    private static void renderOverlay(ResourceLocation texture) {
        CLIENT.func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.func_227626_N_();
        float brightness = FluidImmersionRenderer.CLIENT.field_71439_g.func_70013_c();
        GlStateManager.func_227702_d_((float)brightness, (float)brightness, (float)brightness, (float)0.5f);
        GlStateManager.func_227740_m_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float scrollX = -FluidImmersionRenderer.CLIENT.field_71439_g.field_70177_z / 64.0f;
        float scrollY = FluidImmersionRenderer.CLIENT.field_71439_g.field_70125_A / 64.0f;
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_225582_a_(-1.0, -1.0, -0.5).func_225583_a_(4.0f + scrollX, 4.0f + scrollY).func_181675_d();
        builder.func_225582_a_(1.0, -1.0, -0.5).func_225583_a_(scrollX, 4.0f + scrollY).func_181675_d();
        builder.func_225582_a_(1.0, 1.0, -0.5).func_225583_a_(scrollX, scrollY).func_181675_d();
        builder.func_225582_a_(-1.0, 1.0, -0.5).func_225583_a_(4.0f + scrollX, scrollY).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227737_l_();
        GlStateManager.func_227627_O_();
    }
}

