/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightSurfaceBiomes;
import com.mushroom.midnight.common.util.MidnightUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class GrassColorModifier {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static final int RANGE = 2;
    private static final int FINGERED_GRASS_COLOR = 19322;
    private static final int FINGERED_GRASS_RED = 0;
    private static final int FINGERED_GRASS_GREEN = 75;
    private static final int FINGERED_GRASS_BLUE = 122;

    public static int modifyGrassColor(int color, BlockPos pos) {
        ClientWorld world = GrassColorModifier.CLIENT.field_71441_e;
        if (!MidnightUtil.isMidnightDimension((World)world)) {
            return color;
        }
        Biome biome = world.func_226691_t_(pos);
        if (biome == MidnightSurfaceBiomes.NIGHT_PLAINS) {
            return GrassColorModifier.modifyGrassNightPlains((World)world, pos, color);
        }
        return color;
    }

    private static int modifyGrassNightPlains(World world, BlockPos pos, int color) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int minDistanceSq = Integer.MAX_VALUE;
        for (BlockPos searchPos : BlockPos.func_191531_b((int)(x - 2), (int)(y - 2), (int)(z - 2), (int)(x + 2), (int)(y + 2), (int)(z + 2))) {
            int deltaZ;
            int deltaY;
            int deltaX;
            int distanceSq;
            if (searchPos.equals((Object)pos) || world.func_180495_p(searchPos).func_177230_c() != MidnightBlocks.FINGERED_GRASS || (distanceSq = (deltaX = searchPos.func_177958_n() - x) * deltaX + (deltaY = searchPos.func_177956_o() - y) * deltaY + (deltaZ = searchPos.func_177952_p() - z) * deltaZ) >= minDistanceSq) continue;
            minDistanceSq = distanceSq;
        }
        if (minDistanceSq == Integer.MAX_VALUE) {
            return color;
        }
        double minDistance = Math.sqrt(minDistanceSq) / 2.0;
        if (minDistance >= 1.0) {
            return color;
        }
        if (minDistance <= 0.01) {
            return 19322;
        }
        minDistance = MathHelper.func_151237_a((double)minDistance, (double)0.0, (double)1.0);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int mixedRed = MathHelper.func_76128_c((double)((double)red * minDistance + 0.0 * (1.0 - minDistance))) & 0xFF;
        int mixedGreen = MathHelper.func_76128_c((double)((double)green * minDistance + 75.0 * (1.0 - minDistance))) & 0xFF;
        int mixedBlue = MathHelper.func_76128_c((double)((double)blue * minDistance + 122.0 * (1.0 - minDistance))) & 0xFF;
        return mixedRed << 16 | mixedGreen << 8 | mixedBlue;
    }
}

