/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mushroom.midnight.client.sound.MidnightCaveSound;
import com.mushroom.midnight.client.sound.MidnightIdleSound;
import com.mushroom.midnight.common.util.MidnightUtil;
import com.mushroom.midnight.common.util.SlidingToggle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="midnight", value={Dist.CLIENT})
public class IdleSoundController {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static final ISound IDLE_SOUND = new MidnightIdleSound();
    private static final ISound CAVE_IDLE_SOUND = new MidnightCaveSound();
    public static final SlidingToggle CAVE_ANIMATION = new SlidingToggle(20);

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (!CLIENT.func_147113_T()) {
            ClientPlayerEntity player = IdleSoundController.CLIENT.field_71439_g;
            if (player == null || event.phase == TickEvent.Phase.START) {
                return;
            }
            if (MidnightUtil.isMidnightDimension(player.field_70170_p)) {
                CAVE_ANIMATION.set(player.func_226278_cu_() < 62.0 && !player.field_70170_p.func_175710_j(player.func_180425_c()));
                CAVE_ANIMATION.update();
                IdleSoundController.retainIdleSound(IDLE_SOUND);
                IdleSoundController.retainIdleSound(CAVE_IDLE_SOUND);
            }
        }
    }

    private static void retainIdleSound(ISound sound) {
        SoundHandler soundHandler = CLIENT.func_147118_V();
        if (!soundHandler.func_215294_c(sound)) {
            try {
                soundHandler.func_147683_b(sound);
                soundHandler.func_147682_a(sound);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

