/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.gui.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mushroom.midnight.client.gui.config.ConfigOptionList;
import com.mushroom.midnight.common.config.ifc.ConfigInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ConfigInterfaceScreen
extends Screen {
    public static final ResourceLocation MN_BACKGROUND_LOCATION = new ResourceLocation("midnight:textures/gui/config_background.png");
    private final Screen previousScreen;
    protected final ConfigOptionList optionList;
    protected final ConfigInterface ifc;
    protected final ConfigInterface.Snapshot snapshot;
    private final Button doneButton;
    private final Button cancelButton;
    private List<String> tooltip;
    private boolean revert = true;

    public ConfigInterfaceScreen(Screen previousScreen, ConfigInterface ifc) {
        super(ifc.getTitle());
        this.previousScreen = previousScreen;
        this.ifc = ifc;
        this.snapshot = ifc.createSnapshot();
        this.doneButton = new Button(0, 0, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            ifc.saveAll();
            this.revert = false;
            this.onClose();
        });
        this.cancelButton = new Button(0, 0, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button -> this.onClose());
        this.optionList = new ConfigOptionList(Minecraft.func_71410_x(), this.width, this.height, 32, this.height - 32, 24);
        ifc.fillOptionsScreen(this, this.optionList);
    }

    public void openCategory(ConfigInterface ifc) {
        this.minecraft.func_147108_a((Screen)new ConfigInterfaceScreen(this, ifc));
    }

    protected void init() {
        this.children.add(this.optionList);
        this.optionList.updateSize(this.width, this.height, 32, this.height - 32);
        if (this.ifc.canCancel()) {
            this.cancelButton.x = this.width / 2 - 155;
            this.cancelButton.x = this.width / 2 - 155;
            this.cancelButton.y = this.height - 26;
            this.addButton((Widget)this.cancelButton);
            this.doneButton.x = this.width / 2 + 5;
            this.doneButton.y = this.height - 26;
            this.addButton((Widget)this.doneButton);
        } else {
            this.doneButton.x = this.width / 2 - 100;
            this.doneButton.y = this.height - 26;
            this.doneButton.setWidth(200);
            this.addButton((Widget)this.doneButton);
        }
    }

    public void queueTooltip(List<String> tt) {
        this.tooltip = tt;
    }

    protected void renderTooltip(int mouseX, int mouseY) {
        if (this.tooltip == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int h = 0;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        for (String str : this.tooltip) {
            List wrapped = font.func_78271_c(str, this.width - 64);
            for (String line : wrapped) {
                lines.add(line);
                h += 9;
            }
        }
        if (lines.isEmpty()) {
            return;
        }
        int overlayWidth = this.width - 58;
        int overlayHeight = h + 6;
        int overlayX = 29;
        int overlayY = this.height - 32 - overlayHeight;
        if (mouseX >= overlayX && mouseY >= overlayY && mouseX <= overlayX + overlayWidth && mouseY <= overlayY + overlayHeight) {
            overlayY = 32;
        }
        RenderSystem.disableDepthTest();
        GuiUtils.drawGradientRect((int)50, (int)overlayX, (int)overlayY, (int)(overlayX + overlayWidth), (int)(overlayY + overlayHeight), (int)-1442840576, (int)-1442840576);
        int lineY = overlayY + 3;
        int lineX = 32;
        for (String str : lines) {
            font.func_175063_a(str, (float)lineX, (float)(lineY + 1), -1);
            lineY += 9;
        }
        this.tooltip = null;
    }

    public void onClose() {
        if (this.revert) {
            this.snapshot.revert();
        }
        this.minecraft.func_147108_a(this.previousScreen);
    }

    public void render(int mx, int my, float partialTicks) {
        this.renderDirtBackground(0);
        this.optionList.render(mx, my, partialTicks);
        super.render(mx, my, partialTicks);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 16, -1);
        this.renderTooltip(mx, my);
    }

    public void renderDirtBackground(int yOffset) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(MN_BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_(0.0, (double)this.height, 0.0).func_225583_a_(0.0f, (float)this.height / 32.0f + (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        buff.func_225582_a_((double)this.width, (double)this.height, 0.0).func_225583_a_((float)this.width / 32.0f, (float)this.height / 32.0f + (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        buff.func_225582_a_((double)this.width, 0.0, 0.0).func_225583_a_((float)this.width / 32.0f, (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        buff.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, (float)yOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tess.func_78381_a();
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
    }
}

