/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.gui.config;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mushroom.midnight.client.gui.config.ConfigInterfaceScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class ListConfigOptionList<T>
extends AbstractOptionList<Row<T>> {
    private final Function<Value<T>, Widget> widgetFactory;
    private final Supplier<T> defaultValue;

    public ListConfigOptionList(Minecraft mc, int width, int height, int top, int bottom, int itemHeight, List<T> entries, Function<Value<T>, Widget> widgetFactory, Supplier<T> defaultValue) {
        super(mc, width, height, top, bottom, itemHeight);
        this.widgetFactory = widgetFactory;
        this.defaultValue = defaultValue;
        for (T val : entries) {
            this.addEntry((AbstractList.AbstractListEntry)new Row<T>(this, new Value<T>(val)));
        }
        this.addEntry((AbstractList.AbstractListEntry)new Row(this, null));
        this.updateMoveStates();
    }

    public List<T> collect() {
        ArrayList collected = new ArrayList();
        for (Row row : this.children()) {
            if (row.value == null) continue;
            collected.add(row.value.get());
        }
        return collected;
    }

    public int getRowWidth() {
        return 400;
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    protected void renderHoleBackground(int top, int bottom, int topAlpha, int bottomAlpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(ConfigInterfaceScreen.MN_BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)bottom, 0.0).func_225583_a_(0.0f, (float)bottom / 32.0f).func_225586_a_(64, 64, 64, bottomAlpha).func_181675_d();
        buff.func_225582_a_((double)(this.x0 + this.width), (double)bottom, 0.0).func_225583_a_((float)this.width / 32.0f, (float)bottom / 32.0f).func_225586_a_(64, 64, 64, bottomAlpha).func_181675_d();
        buff.func_225582_a_((double)(this.x0 + this.width), (double)top, 0.0).func_225583_a_((float)this.width / 32.0f, (float)top / 32.0f).func_225586_a_(64, 64, 64, topAlpha).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)top, 0.0).func_225583_a_(0.0f, (float)top / 32.0f).func_225586_a_(64, 64, 64, topAlpha).func_181675_d();
        tess.func_78381_a();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        int scrollbarLeft = this.getScrollbarPosition();
        int scrollbarRight = scrollbarLeft + 6;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(ConfigInterfaceScreen.MN_BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        tess.func_78381_a();
        int left = this.getRowLeft();
        int top = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(left, top, tess);
        }
        this.renderList(left, top, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)(this.y0 + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)(this.y0 + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        tess.func_78381_a();
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)(this.y1 - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)(this.y1 - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        tess.func_78381_a();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int scrollbarHeight = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            scrollbarHeight = MathHelper.func_76125_a((int)scrollbarHeight, (int)32, (int)(this.y1 - this.y0 - 8));
            int scrollbarY = (int)this.getScrollAmount() * (this.y1 - this.y0 - scrollbarHeight) / maxScroll + this.y0;
            if (scrollbarY < this.y0) {
                scrollbarY = this.y0;
            }
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)scrollbarLeft, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarLeft, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)scrollbarLeft, (double)(scrollbarY + scrollbarHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)(scrollbarY + scrollbarHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)scrollbarY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarLeft, (double)scrollbarY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)scrollbarLeft, (double)(scrollbarY + scrollbarHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)(scrollbarRight - 1), (double)(scrollbarY + scrollbarHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)(scrollbarRight - 1), (double)scrollbarY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarLeft, (double)scrollbarY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        this.renderDecorations(mouseX, mouseY);
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.children().get(index));
    }

    protected int getIndex(Row<T> row) {
        return this.children().indexOf(row);
    }

    protected void addNew(int index) {
        this.children().add(index, new Row<T>(this, new Value<T>(this.defaultValue.get())));
        for (Row row : this.children()) {
            row.updateMoveState();
        }
    }

    public boolean keyPressed(int key, int scan, int mods) {
        if (this.getSelected() != null) {
            Row sel = (Row)this.getSelected();
            if (!sel.widget.isFocused()) {
                if (key == 265 && Screen.hasShiftDown()) {
                    int i = this.getIndex(sel);
                    if (i > 0) {
                        this.children().remove(i);
                        this.children().add(i - 1, sel);
                    }
                    return true;
                }
                if (key == 265 && Screen.hasShiftDown()) {
                    int i = this.getIndex(sel);
                    if (i < this.getItemCount() - 1) {
                        this.children().remove(i);
                        this.children().add(i + 1, sel);
                    }
                    return true;
                }
                if (key == 259) {
                    this.removeEntry((AbstractList.AbstractListEntry)sel);
                    return true;
                }
            }
        }
        return super.keyPressed(key, scan, mods);
    }

    protected void updateMoveStates() {
        for (Row row : this.children()) {
            row.updateMoveState();
        }
    }

    public static class Value<T> {
        private T value;

        public Value(T value) {
            this.value = value;
        }

        public void set(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }
    }

    static class Row<T>
    extends AbstractOptionList.Entry<Row<T>> {
        protected final ListConfigOptionList<T> list;
        protected final Widget widget;
        protected final Button add;
        protected final Button remove;
        protected final Button up;
        protected final Button down;
        protected final Value<T> value;
        private final List<IGuiEventListener> children;

        Row(ListConfigOptionList<T> list, Value<T> value) {
            this.list = list;
            this.widget = value == null ? null : (Widget)((ListConfigOptionList)list).widgetFactory.apply(value);
            this.value = value;
            this.add = new Button(0, 0, 20, 20, "+", btn -> list.addNew(list.getIndex(this)));
            this.remove = value == null ? null : new Button(0, 0, 20, 20, "-", btn -> {
                ((ListConfigOptionList)list).removeEntry((AbstractList.AbstractListEntry)this);
                list.updateMoveStates();
            });
            this.up = value == null ? null : new Button(0, 0, 20, 20, "\u23f6", btn -> {
                int i = list.getIndex(this);
                if (i > 0) {
                    list.children().remove(i);
                    list.children().add(i - 1, this);
                }
                list.updateMoveStates();
            });
            this.down = value == null ? null : new Button(0, 0, 20, 20, "\u23f7", btn -> {
                int i = list.getIndex(this);
                if (i < ((ListConfigOptionList)list).getItemCount() - 2) {
                    list.children().remove(i);
                    list.children().add(i + 1, this);
                }
                list.updateMoveStates();
            });
            this.children = Lists.newArrayList();
            if (this.widget != null) {
                this.children.add((IGuiEventListener)this.widget);
            }
            this.children.add((IGuiEventListener)this.add);
            if (this.remove != null) {
                this.children.add((IGuiEventListener)this.remove);
            }
            if (this.up != null) {
                this.children.add((IGuiEventListener)this.up);
            }
            if (this.down != null) {
                this.children.add((IGuiEventListener)this.down);
            }
        }

        public List<? extends IGuiEventListener> children() {
            return this.children;
        }

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            if (this.widget != null) {
                this.widget.x = left + width / 2 - 155;
                this.widget.y = top + 2;
                this.widget.setWidth(220);
                this.widget.render(mouseX, mouseY, partialTicks);
            }
            this.add.x = left + width / 2 + 155 - 80;
            this.add.y = top + 2;
            this.add.render(mouseX, mouseY, partialTicks);
            if (this.remove != null) {
                this.remove.x = left + width / 2 + 155 - 60;
                this.remove.y = top + 2;
                this.remove.render(mouseX, mouseY, partialTicks);
            }
            if (this.up != null) {
                this.up.x = left + width / 2 + 155 - 40;
                this.up.y = top + 2;
                this.up.active = this.list.getIndex(this) > 0;
                this.up.render(mouseX, mouseY, partialTicks);
            }
            if (this.down != null) {
                this.down.x = left + width / 2 + 155 - 20;
                this.down.y = top + 2;
                this.down.render(mouseX, mouseY, partialTicks);
            }
        }

        private void updateMoveState() {
            if (this.up != null) {
                boolean bl = this.up.active = this.list.getIndex(this) > 0;
            }
            if (this.down != null) {
                this.down.active = this.list.getIndex(this) < ((ListConfigOptionList)this.list).getItemCount() - 2;
            }
        }
    }
}

