/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.model;

import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class ModelPartAnimator {
    public void bob(ModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float limbSwing, float limbSwingAmount) {
        box.field_78797_d = this.computeAnimation(speed, degree, invert, offset, weight, limbSwing, limbSwingAmount);
    }

    public void walk(ModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float limbSwing, float limbSwingAmount) {
        box.field_78795_f = this.computeAnimation(speed, degree, invert, offset, weight, limbSwing, limbSwingAmount);
    }

    public void swing(ModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float limbSwing, float limbSwingAmount) {
        box.field_78796_g = this.computeAnimation(speed, degree, invert, offset, weight, limbSwing, limbSwingAmount);
    }

    public void flap(ModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float limbSwing, float limbSwingAmount) {
        box.field_78808_h = this.computeAnimation(speed, degree, invert, offset, weight, limbSwing, limbSwingAmount);
    }

    public void chainSwing(ModelRenderer[] boxes, float speed, float degree, boolean invert, double rootOffset, float swing, float swingAmount) {
        float offset = this.computeChainOffset(boxes, rootOffset);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78796_g = this.computeChainRotation(speed, degree, invert, offset, index, swing, swingAmount);
        }
    }

    public void chainWave(ModelRenderer[] boxes, float speed, float degree, boolean invert, double rootOffset, float swing, float swingAmount) {
        float offset = this.computeChainOffset(boxes, rootOffset);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78795_f = this.computeChainRotation(speed, degree, invert, offset, index, swing, swingAmount);
        }
    }

    public void chainFlap(ModelRenderer[] boxes, float speed, float degree, boolean invert, double rootOffset, float swing, float swingAmount) {
        float offset = this.computeChainOffset(boxes, rootOffset);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78808_h = this.computeChainRotation(speed, degree, invert, offset, index, swing, swingAmount);
        }
    }

    public float computeChainRotation(float speed, float degree, boolean invert, float offset, int boxIndex, float swing, float swingAmount) {
        float theta = swing * speed + offset * (float)boxIndex;
        float rotation = MathHelper.func_76134_b((float)theta) * swingAmount * degree;
        return invert ? -rotation : rotation;
    }

    public float computeChainOffset(ModelRenderer[] boxes, double rootOffset) {
        return (float)(rootOffset * Math.PI / (double)(2 * boxes.length));
    }

    public float computeAnimation(float speed, float degree, boolean invert, float offset, float weight, float limbSwing, float limbSwingAmount) {
        float theta = limbSwing * speed + offset;
        float scaledWeight = weight * limbSwingAmount;
        float rotation = MathHelper.func_76134_b((float)theta) * degree * limbSwingAmount + scaledWeight;
        return invert ? -rotation : rotation;
    }
}

