/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FurnaceFlameParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite spriteSet;

    public FurnaceFlameParticle(IAnimatedSprite spriteSet, World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.field_187129_i = this.field_187129_i * (double)0.01f + motionX;
        this.field_187130_j = this.field_187130_j * (double)0.01f + motionY;
        this.field_187131_k = this.field_187131_k * (double)0.01f + motionZ;
        this.field_187126_f += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187127_g += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187128_h += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.spriteSet = spriteSet;
        this.func_217566_b(this.spriteSet);
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public float func_217561_b(float partialTicks) {
        float ratio = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        return this.field_70544_f * (1.0f - ratio * ratio * 0.5f);
    }

    public int func_189214_a(float partialTicks) {
        float ratio = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        ratio = MathHelper.func_76131_a((float)ratio, (float)0.0f, (float)1.0f);
        int i = super.func_189214_a(partialTicks);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(ratio * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void func_189213_a() {
        if (this.field_70546_d++ < this.field_70547_e) {
            this.func_217566_b(this.spriteSet);
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= (double)0.96f;
            this.field_187130_j *= (double)0.96f;
            this.field_187131_k *= (double)0.96f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType particleType, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FurnaceFlameParticle(this.spriteSet, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

