/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SporchParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite spriteSet;
    private final float flameScale;
    private final int MAX_FRAME_ID = 2;
    private int currentFrame = 0;
    private boolean directionRight = true;
    private int lastTick = 0;

    private SporchParticle(IAnimatedSprite spriteSet, World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.field_187129_i = this.field_187129_i * (double)0.01f + motionX;
        this.field_187130_j = this.field_187130_j * (double)0.01f + motionY;
        this.field_187131_k = this.field_187131_k * (double)0.01f + motionZ;
        this.field_187126_f += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187127_g += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187128_h += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_70544_f = 0.2f;
        this.flameScale = 0.2f;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.spriteSet = spriteSet;
        this.func_217566_b(this.spriteSet);
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.func_187113_k() && this.field_70546_d++ < this.field_70547_e) {
            this.func_217566_b(this.spriteSet);
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Entity entity = renderInfo.func_216773_g();
        if (entity.field_70173_aa >= this.lastTick + 5) {
            if (this.currentFrame == 2) {
                this.directionRight = false;
            } else if (this.currentFrame == 0) {
                this.directionRight = true;
            }
            this.currentFrame += this.directionRight ? 1 : -1;
            this.lastTick = entity.field_70173_aa;
        }
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_70544_f = this.flameScale * (1.0f - f * f * 0.5f);
        super.func_225606_a_(buffer, renderInfo, partialTicks);
    }

    public int func_189214_a(float partialTick) {
        float f = ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_189214_a(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType particleType, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SporchParticle(this.spriteSet, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

