/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.render.block;

import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.tile.MidnightChestTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MidnightChestBlockRenderer
extends ChestTileEntityRenderer<MidnightChestTileEntity> {
    public static final Material TEXTURE_SHADOWROOT_RIGHT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/shadowroot_chest_right"));
    public static final Material TEXTURE_SHADOWROOT_LEFT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/shadowroot_chest_left"));
    public static final Material TEXTURE_SHADOWROOT_NORMAL = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/shadowroot_chest"));
    public static final Material TEXTURE_DARK_WILLOW_RIGHT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dark_willow_chest_right"));
    public static final Material TEXTURE_DARK_WILLOW_LEFT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dark_willow_chest_left"));
    public static final Material TEXTURE_DARK_WILLOW_NORMAL = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dark_willow_chest"));
    public static final Material TEXTURE_DEAD_WOOD_RIGHT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dead_wood_chest_right"));
    public static final Material TEXTURE_DEAD_WOOD_LEFT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dead_wood_chest_left"));
    public static final Material TEXTURE_DEAD_WOOD_NORMAL = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dead_wood_chest"));
    public static final Material TEXTURE_NIGHTSHROOM_RIGHT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/nightshroom_chest_right"));
    public static final Material TEXTURE_NIGHTSHROOM_LEFT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/nightshroom_chest_left"));
    public static final Material TEXTURE_NIGHTSHROOM_NORMAL = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/nightshroom_chest"));
    public static final Material TEXTURE_DEWSHROOM_RIGHT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dewshroom_chest_right"));
    public static final Material TEXTURE_DEWSHROOM_LEFT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dewshroom_chest_left"));
    public static final Material TEXTURE_DEWSHROOM_NORMAL = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/dewshroom_chest"));
    public static final Material TEXTURE_VIRIDSHROOM_RIGHT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/viridshroom_chest_right"));
    public static final Material TEXTURE_VIRIDSHROOM_LEFT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/viridshroom_chest_left"));
    public static final Material TEXTURE_VIRIDSHROOM_NORMAL = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/viridshroom_chest"));
    public static final Material TEXTURE_BOGSHROOM_RIGHT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/bogshroom_chest_right"));
    public static final Material TEXTURE_BOGSHROOM_LEFT = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/bogshroom_chest_left"));
    public static final Material TEXTURE_BOGSHROOM_NORMAL = MidnightChestBlockRenderer.getChestMaterial(new ResourceLocation("midnight", "entities/chest/bogshroom_chest"));

    public MidnightChestBlockRenderer(TileEntityRendererDispatcher p_i226008_1_) {
        super(p_i226008_1_);
    }

    public Material getMaterial(MidnightChestTileEntity chest, @Nonnull ChestType chestType) {
        Block chestModel = chest.getChestModel();
        if (chestModel == MidnightBlocks.SHADOWROOT_CHEST) {
            return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_SHADOWROOT_NORMAL, TEXTURE_SHADOWROOT_LEFT, TEXTURE_SHADOWROOT_RIGHT);
        }
        if (chestModel == MidnightBlocks.DARK_WILLOW_CHEST) {
            return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_DARK_WILLOW_NORMAL, TEXTURE_DARK_WILLOW_LEFT, TEXTURE_DARK_WILLOW_RIGHT);
        }
        if (chestModel == MidnightBlocks.DEAD_WOOD_CHEST) {
            return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_DEAD_WOOD_NORMAL, TEXTURE_DEAD_WOOD_LEFT, TEXTURE_DEAD_WOOD_RIGHT);
        }
        if (chestModel == MidnightBlocks.NIGHTSHROOM_CHEST) {
            return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_NIGHTSHROOM_NORMAL, TEXTURE_NIGHTSHROOM_LEFT, TEXTURE_NIGHTSHROOM_RIGHT);
        }
        if (chestModel == MidnightBlocks.DEWSHROOM_CHEST) {
            return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_DEWSHROOM_NORMAL, TEXTURE_DEWSHROOM_LEFT, TEXTURE_DEWSHROOM_RIGHT);
        }
        if (chestModel == MidnightBlocks.VIRIDSHROOM_CHEST) {
            return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_VIRIDSHROOM_NORMAL, TEXTURE_VIRIDSHROOM_LEFT, TEXTURE_VIRIDSHROOM_RIGHT);
        }
        if (chestModel == MidnightBlocks.BOGSHROOM_CHEST) {
            return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_BOGSHROOM_NORMAL, TEXTURE_BOGSHROOM_LEFT, TEXTURE_BOGSHROOM_RIGHT);
        }
        return MidnightChestBlockRenderer.getChestMaterial(chestType, TEXTURE_SHADOWROOT_NORMAL, TEXTURE_SHADOWROOT_LEFT, TEXTURE_SHADOWROOT_RIGHT);
    }

    private static Material getChestMaterial(ResourceLocation p_228774_0_) {
        return new Material(Atlases.field_228747_f_, p_228774_0_);
    }

    private static Material getChestMaterial(ChestType p_228772_0_, Material p_228772_1_, Material p_228772_2_, Material p_228772_3_) {
        switch (p_228772_0_) {
            case LEFT: {
                return p_228772_2_;
            }
            case RIGHT: {
                return p_228772_3_;
            }
        }
        return p_228772_1_;
    }
}

