/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.render.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mushroom.midnight.client.model.RiftPortalBlockModel;
import com.mushroom.midnight.common.tile.RiftPortalTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class RiftPortalBlockRenderer
extends TileEntityRenderer<RiftPortalTileEntity> {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static final ResourceLocation[] MASKS = new ResourceLocation[]{new ResourceLocation("midnight", "textures/effects/rift_portal_mask_1.png"), new ResourceLocation("midnight", "textures/effects/rift_portal_mask_2.png")};
    private static final RiftPortalBlockModel BLOCK_MODEL = new RiftPortalBlockModel();

    public RiftPortalBlockRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(RiftPortalTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn == null) {
            return;
        }
        float closeAnimation = tileEntityIn.getCloseAnimation(partialTicks);
        if (closeAnimation >= 1.0f) {
            return;
        }
        float alpha = 1.0f - closeAnimation;
        BlockPos pos = tileEntityIn.func_174877_v();
        long seed = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        long textureSeed = seed ^ 0x71F40DEE1F423D8DL;
        long rotationSeed = seed ^ 0x74D9B5A7E9B6BE3L;
        matrixStackIn.func_227860_a_();
        CLIENT.func_110434_K().func_110577_a(MASKS[(int)(textureSeed & 1L)]);
        BLOCK_MODEL.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)MASKS[(int)(textureSeed & 1L)])), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
        matrixStackIn.func_227865_b_();
    }
}

