/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.client.shader.PresentShaderHandle;
import com.mushroom.midnight.client.shader.ShaderHandle;
import com.mushroom.midnight.client.shader.VoidShaderHandle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.shader.ShaderInstance;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.lwjgl.opengl.GL11;

public class WorldShader
implements ISelectiveResourceReloadListener {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private final ResourceLocation location;
    private final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    private ShaderInstance instance;
    private boolean initialized;

    public WorldShader(ResourceLocation location) {
        this.location = location;
        ((IReloadableResourceManager)MC.func_195551_G()).func_219534_a((IFutureReloadListener)this);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.SHADERS)) {
            if (this.instance != null) {
                this.instance.close();
            }
            for (ResourceLocation texture : this.textures.values()) {
                this.prepareTexture(texture);
            }
            this.initialized = false;
        }
    }

    public WorldShader withTextureSampler(String key, ResourceLocation texture) {
        this.prepareTexture(texture);
        this.textures.put(key, texture);
        return this;
    }

    private void prepareTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GlStateManager.func_227677_b_((int)3553, (int)10241, (int)9729);
        GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9729);
        GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10497);
        GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10497);
    }

    public ShaderHandle use(Consumer<ShaderHandle> setup) {
        ShaderHandle handle = this.makeHandle();
        setup.accept(handle);
        handle.getUniform("FogMode").func_148090_a((float)GL11.glGetInteger((int)2917));
        handle.use();
        return handle;
    }

    private ShaderHandle makeHandle() {
        ShaderInstance manager = this.get();
        if (manager != null) {
            return new PresentShaderHandle(manager);
        }
        return new VoidShaderHandle();
    }

    private ShaderInstance get() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            Minecraft mc = Minecraft.func_71410_x();
            this.instance = new ShaderInstance(mc.func_195551_G(), this.location.toString());
            for (Map.Entry<String, ResourceLocation> entry : this.textures.entrySet()) {
                Texture texture = mc.func_110434_K().func_229267_b_(entry.getValue());
                this.instance.func_216537_a(entry.getKey(), (Object)texture);
            }
        }
        catch (IOException e) {
            Midnight.LOGGER.error("Failed to load shader {}", (Object)this.location, (Object)e);
        }
        finally {
            this.initialized = true;
        }
    }
}

