/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.RiftTraveller;
import com.mushroom.midnight.common.capability.RifterCapturable;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.event.RifterCaptureEvent;
import com.mushroom.midnight.common.event.RifterReleaseEvent;
import com.mushroom.midnight.common.registry.MidnightEffects;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="midnight")
public class CommonEventHandler {
    public static final float SOUND_TRAVEL_DISTANCE_MULTIPLIER = 2.0f;
    private static final ThreadLocal<Boolean> IS_TICKING_MIDNIGHT = ThreadLocal.withInitial(() -> false);

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("midnight", "rift_traveller"), (ICapabilityProvider)new RiftTraveller());
            if (!(event.getObject() instanceof PlayerEntity)) {
                ResourceLocation rl = EntityType.func_200718_a((EntityType)((Entity)event.getObject()).func_200600_R());
                if (rl == null) {
                    return;
                }
                if (event.getObject() instanceof AnimalEntity ? ((List)MidnightConfig.compat.notCapturableAnimals.get()).stream().anyMatch(p -> p.contains(":") ? rl.toString().equals(p) : rl.func_110624_b().equals(p)) : !((List)MidnightConfig.compat.capturableEntities.get()).contains(rl.toString())) {
                    return;
                }
            }
            event.addCapability(new ResourceLocation("midnight", "rifter_captured"), (ICapabilityProvider)new RifterCapturable());
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        entity.getCapability(Midnight.RIFT_TRAVELLER_CAP).ifPresent(traveller -> traveller.update((Entity)entity));
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            World world = event.world;
            IS_TICKING_MIDNIGHT.set(MidnightUtil.isMidnightDimension(world));
        } else {
            IS_TICKING_MIDNIGHT.set(false);
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity trueSource = source.func_76346_g();
        if (trueSource instanceof LivingEntity && ((LivingEntity)trueSource).func_70644_a(MidnightEffects.STUNNED)) {
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void onRifterCapture(RifterCaptureEvent event) {
        LivingEntity captured = event.getCaptured();
        if (captured instanceof PlayerEntity) {
            captured.func_213323_x_();
        }
    }

    @SubscribeEvent
    public static void onRifterRelease(RifterReleaseEvent event) {
        LivingEntity captured = event.getCaptured();
        if (captured instanceof PlayerEntity) {
            captured.func_213323_x_();
        }
    }

    @SubscribeEvent
    public static void setEyeHeight(EntityEvent.EyeHeight event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && RifterCapturable.isCaptured((Entity)(player = (PlayerEntity)event.getEntity()))) {
            event.setNewHeight(player.func_213311_cf() / 2.0f);
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundAtEntityEvent event) {
        if (IS_TICKING_MIDNIGHT.get().booleanValue()) {
            event.setVolume(event.getVolume() * 2.0f);
        }
    }

    @SubscribeEvent
    public static void commandEvent(CommandEvent event) {
        String message = event.getParseResults().getReader().getString();
        try {
            ServerPlayerEntity player = ((CommandSource)event.getParseResults().getContext().getSource()).func_197035_h();
            World world = player.func_130014_f_();
            message = message.replace("/", "");
            Command command = event.getParseResults().getContext().getCommand();
            if (command == null) {
                return;
            }
            if (message.contains("locate midnight:shadowroot_guardtower") || message.contains("locate midnight:well")) {
                player.func_145747_a(new TranslationTextComponent("The ability to " + message + " has been disabled. This is due to a bug that will be fixed in The Midnight 0.6.0.", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                event.setCanceled(true);
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }
}

