/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mushroom.midnight.common.biome.BiomeSpawnEntry;
import com.mushroom.midnight.common.util.INumberGenerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum MidnightBiomeGroup {
    SURFACE,
    SURFACE_HILLS,
    SURFACE_POCKET,
    UNDERGROUND,
    UNDERGROUND_POCKET;

    private final List<BiomeSpawnEntry> spawnEntries = new ArrayList<BiomeSpawnEntry>();
    private final Int2ObjectMap<Pool> pools = new Int2ObjectOpenHashMap();
    private Pool globalPool;

    public void add(BiomeSpawnEntry ... entries) {
        Collections.addAll(this.spawnEntries, entries);
        this.pools.clear();
        this.globalPool = null;
    }

    @Nonnull
    public Pool getGlobalPool() {
        if (this.globalPool == null) {
            this.globalPool = new ListPool(this.spawnEntries);
        }
        return this.globalPool;
    }

    @Nonnull
    public Pool getPoolForBiome(int biomeId) {
        Pool pool = (Pool)this.pools.get(biomeId);
        if (pool == null) {
            pool = this.createPool(biomeId);
            this.pools.put(biomeId, (Object)pool);
        }
        return pool;
    }

    private Pool createPool(int biomeId) {
        List applicableEntries = this.spawnEntries.stream().filter(e -> e.canReplace(biomeId)).collect(Collectors.toList());
        if (applicableEntries.isEmpty()) {
            return EmptyPool.INSTANCE;
        }
        return new ListPool(applicableEntries);
    }

    private static class EmptyPool
    implements Pool {
        public static final Pool INSTANCE = new EmptyPool();

        private EmptyPool() {
        }

        @Override
        @Nullable
        public BiomeSpawnEntry selectWeight(INumberGenerator numberGenerator) {
            return null;
        }

        @Override
        @Nullable
        public BiomeSpawnEntry selectChance(INumberGenerator numberGenerator) {
            return null;
        }
    }

    private static class ListPool
    implements Pool {
        private final List<BiomeSpawnEntry> entries;
        private final int totalWeight;

        private ListPool(List<BiomeSpawnEntry> entries) {
            this.entries = entries;
            this.totalWeight = entries.stream().mapToInt(BiomeSpawnEntry::getValue).sum();
        }

        @Override
        @Nullable
        public BiomeSpawnEntry selectWeight(INumberGenerator numberGenerator) {
            int weight = numberGenerator.nextInt(this.totalWeight);
            for (BiomeSpawnEntry entry : this.entries) {
                if ((weight -= entry.getValue()) >= 0) continue;
                return entry;
            }
            return null;
        }

        @Override
        @Nullable
        public BiomeSpawnEntry selectChance(INumberGenerator numberGenerator) {
            for (BiomeSpawnEntry entry : this.entries) {
                if (numberGenerator.nextInt(entry.getValue()) != 0) continue;
                return entry;
            }
            return null;
        }
    }

    public static interface Pool {
        @Nullable
        public BiomeSpawnEntry selectWeight(INumberGenerator var1);

        @Nullable
        public BiomeSpawnEntry selectChance(INumberGenerator var1);
    }
}

