/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.world.LayeredSurfaceBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public final class MidnightSurfaceBuilders {
    public static final SurfaceBuilder<SurfaceBuilderConfig> SURFACE = new LayeredSurfaceBuilder(SurfaceBuilderConfig::func_215455_a, 0, 0);
    public static final SurfaceBuilder<SurfaceBuilderConfig> CAVERN = new LayeredSurfaceBuilder(SurfaceBuilderConfig::func_215455_a, 1, Integer.MAX_VALUE).withMaxY(58);
    public static final SurfaceBuilderConfig GRASS_DIRT_MUD_CONFIG = new SurfaceBuilderConfig(MidnightBlocks.GRASS_BLOCK.func_176223_P(), MidnightBlocks.DIRT.func_176223_P(), MidnightBlocks.DECEITFUL_MUD.func_176223_P());
    public static final SurfaceBuilderConfig NIGHTSTONE_CONFIG = new SurfaceBuilderConfig(MidnightBlocks.NIGHTSTONE.func_176223_P(), MidnightBlocks.NIGHTSTONE.func_176223_P(), MidnightBlocks.NIGHTSTONE.func_176223_P());
    public static final SurfaceBuilderConfig PEAT_CONFIG = new SurfaceBuilderConfig(MidnightBlocks.DECEITFUL_PEAT.func_176223_P(), MidnightBlocks.DECEITFUL_PEAT.func_176223_P(), MidnightBlocks.DECEITFUL_MUD.func_176223_P());
    public static final SurfaceBuilderConfig MUD_CONFIG = new SurfaceBuilderConfig(MidnightBlocks.DECEITFUL_MUD.func_176223_P(), MidnightBlocks.DECEITFUL_MUD.func_176223_P(), MidnightBlocks.DECEITFUL_MUD.func_176223_P());
    public static final SurfaceBuilderConfig MYCELIUM_CONFIG = new SurfaceBuilderConfig(MidnightBlocks.MYCELIUM.func_176223_P(), MidnightBlocks.NIGHTSTONE.func_176223_P(), MidnightBlocks.NIGHTSTONE.func_176223_P());
    public static final SurfaceBuilderConfig COARSE_DIRT_CONFIG = new SurfaceBuilderConfig(MidnightBlocks.COARSE_DIRT.func_176223_P(), MidnightBlocks.COARSE_DIRT.func_176223_P(), MidnightBlocks.COARSE_DIRT.func_176223_P());
    public static final SurfaceBuilder<SurfaceBuilderConfig> PATCHED_MUD = new PatchedSurfaceBuilder(SurfaceBuilderConfig::func_215455_a, MUD_CONFIG, 0.05);
    public static final SurfaceBuilder<SurfaceBuilderConfig> PATCHED_COARSE_DIRT = new PatchedSurfaceBuilder(SurfaceBuilderConfig::func_215455_a, COARSE_DIRT_CONFIG, -1.75);

    private static class PatchedSurfaceBuilder
    extends SurfaceBuilder<SurfaceBuilderConfig> {
        private final SurfaceBuilderConfig patchConfig;
        private final double threshold;

        public PatchedSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> deserialize, SurfaceBuilderConfig patchConfig, double threshold) {
            super(deserialize);
            this.patchConfig = patchConfig;
            this.threshold = threshold;
        }

        public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
            if ((noise += (random.nextDouble() - 0.5) * 0.1) < this.threshold) {
                config = this.patchConfig;
            }
            SURFACE.func_205610_a_(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        }
    }
}

