/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome.cavern;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mushroom.midnight.common.biome.ConfigurableBiome;
import com.mushroom.midnight.common.world.MidnightChunkGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class CavernousBiome
extends ForgeRegistryEntry<CavernousBiome>
implements ConfigurableBiome {
    protected final ConfiguredSurfaceBuilder<?> surfaceBuilder;
    protected final float cavernDensity;
    protected final float floorHeight;
    protected final float ceilingHeight;
    protected final float heightScale;
    protected final float pillarWeight;
    protected final Multimap<GenerationStage.Carving, ConfiguredCarver<?>> carvers = HashMultimap.create();
    protected final Multimap<GenerationStage.Decoration, ConfiguredFeature<?, ?>> features = HashMultimap.create();
    protected final List<ConfiguredFeature<?, ?>> flowers = new ArrayList();
    protected final Map<Structure<?>, IFeatureConfig> structures = new HashMap();
    protected final Map<EntityClassification, List<Biome.SpawnListEntry>> spawns = new HashMap<EntityClassification, List<Biome.SpawnListEntry>>();

    public CavernousBiome(Properties properties) {
        Preconditions.checkNotNull((Object)properties.surfaceBuilder, (Object)"must have surfacebuilder");
        this.surfaceBuilder = properties.surfaceBuilder;
        this.cavernDensity = properties.cavernDensity;
        this.floorHeight = properties.floorHeight;
        this.ceilingHeight = properties.ceilingHeight;
        this.heightScale = properties.heightScale;
        this.pillarWeight = properties.pillarWeight;
    }

    @Override
    public void add(GenerationStage.Decoration stage, ConfiguredFeature feature) {
        if (feature.field_222737_a == Feature.field_214484_aL) {
            this.flowers.add(feature);
        }
        this.features.put((Object)stage, (Object)feature);
    }

    @Override
    public <C extends ICarverConfig> void add(GenerationStage.Carving stage, ConfiguredCarver<C> carver) {
        this.carvers.put((Object)stage, carver);
    }

    public <C extends IFeatureConfig> void add(Structure<C> structure, C config) {
        this.structures.put(structure, config);
    }

    public <C extends IFeatureConfig> void addStructure(ConfiguredFeature<C, ? extends Structure<C>> structureIn) {
        this.structures.put((Structure<?>)structureIn.field_222737_a, structureIn.field_222738_b);
    }

    @Override
    public <C extends IFeatureConfig> void add(ConfiguredFeature<C, ? extends Structure<C>> structure) {
        this.addStructure(structure);
    }

    @Override
    public void add(EntityClassification classification, Biome.SpawnListEntry entry) {
        this.getSpawnsFor(classification).add(entry);
    }

    @Override
    public void placeFeatures(GenerationStage.Decoration stage, MidnightChunkGenerator generator, WorldGenRegion world, long seed, SharedSeedRandom random, BlockPos origin) {
        int index = 0;
        for (ConfiguredFeature feature : this.features.get((Object)stage)) {
            random.func_202426_b(seed, index, stage.ordinal());
            feature.func_222734_a((IWorld)world, (ChunkGenerator)generator, (Random)random, origin);
            ++index;
        }
    }

    @Override
    public void generateSurface(SharedSeedRandom random, IChunk chunk, int x, int z, int startY, double depth, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        this.surfaceBuilder.func_215451_a(seed);
        this.surfaceBuilder.func_215450_a((Random)random, chunk, Biomes.field_180279_ad, x, z, startY, depth, defaultBlock, defaultFluid, seaLevel, seed);
    }

    @Override
    public Collection<ConfiguredCarver<?>> getCarversFor(GenerationStage.Carving stage) {
        return this.carvers.get((Object)stage);
    }

    @Override
    public List<Biome.SpawnListEntry> getSpawnsFor(EntityClassification classification) {
        return this.spawns.computeIfAbsent(classification, c -> new ArrayList());
    }

    public float getCavernDensity() {
        return this.cavernDensity;
    }

    public float getFloorHeight() {
        return this.floorHeight;
    }

    public float getCeilingHeight() {
        return this.ceilingHeight;
    }

    public float getHeightScale() {
        return this.heightScale;
    }

    public float getPillarWeight() {
        return this.pillarWeight;
    }

    public static class Properties {
        private ConfiguredSurfaceBuilder<?> surfaceBuilder;
        private float cavernDensity = -5.0f;
        private float floorHeight = 0.0f;
        private float ceilingHeight = 1.0f;
        private float heightScale = 0.1f;
        private float pillarWeight = 1.0f;

        protected Properties() {
        }

        public <SC extends ISurfaceBuilderConfig> Properties surfaceBuilder(SurfaceBuilder<SC> surface, SC config) {
            this.surfaceBuilder = new ConfiguredSurfaceBuilder(surface, config);
            return this;
        }

        public Properties cavernDensity(float density) {
            this.cavernDensity = density;
            return this;
        }

        public Properties floorHeight(float floorHeight) {
            this.floorHeight = floorHeight;
            return this;
        }

        public Properties ceilingHeight(float ceilingHeight) {
            this.ceilingHeight = ceilingHeight;
            return this;
        }

        public Properties heightScale(float heightScale) {
            this.heightScale = heightScale;
            return this;
        }

        public Properties pillarWeight(float pillarWeight) {
            this.pillarWeight = pillarWeight;
            return this;
        }
    }
}

