/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.google.common.collect.ImmutableList;
import com.mushroom.midnight.common.block.MidnightPlantBlock;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.util.MidnightDamageSource;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;

public class BladeshroomBlock
extends MidnightPlantBlock
implements IGrowable {
    public static final EnumProperty<Stage> STAGE = EnumProperty.func_177709_a((String)"stage", Stage.class);
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final int REGROW_CHANCE = 10;
    private static final ImmutableList<VoxelShape> STEM_BOUNDS = new ImmutableList.Builder().add((Object)BladeshroomBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)).add((Object)BladeshroomBlock.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)).add((Object)BladeshroomBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0)).add((Object)BladeshroomBlock.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0)).add((Object)BladeshroomBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0)).add((Object)BladeshroomBlock.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)).build();
    private static final ImmutableList<VoxelShape> BOUNDS = new ImmutableList.Builder().add((Object)BladeshroomBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)).add((Object)BladeshroomBlock.func_208617_a((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)).add((Object)BladeshroomBlock.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)8.0)).add((Object)BladeshroomBlock.func_208617_a((double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0, (double)16.0)).add((Object)BladeshroomBlock.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0)).add((Object)BladeshroomBlock.func_208617_a((double)8.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0)).build();
    private static final DamageSource BLADESHROOM_DAMAGE = new MidnightDamageSource("bladeshroom").func_76348_h().func_151518_m();

    public BladeshroomBlock(Block.Properties properties) {
        super(properties, false);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(STAGE, (Comparable)((Object)Stage.SPORE))).func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN));
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return state.func_177229_b(STAGE) == Stage.CAPPED ? PathNodeType.DAMAGE_CACTUS : super.getAiPathNodeType(state, world, pos, entity);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos attachedPos = pos.func_177972_a(facing);
        return Block.func_220056_d((BlockState)world.func_180495_p(attachedPos), (IBlockReader)world, (BlockPos)attachedPos, (Direction)facing);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int facingIndex = ((Direction)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return state.func_177229_b(STAGE) == Stage.CAPPED ? (VoxelShape)BOUNDS.get(facingIndex) : (VoxelShape)STEM_BOUNDS.get(facingIndex);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l().func_176734_d());
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d() == facing && !state.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (state.func_177229_b(STAGE) == Stage.CAPPED) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)MidnightItems.BLADESHROOM_CAP));
            world.func_175656_a(pos, (BlockState)state.func_206870_a(STAGE, (Comparable)((Object)Stage.STEM)));
            if ((Integer)MidnightConfig.logic.bladeshroomDamageChance.get() != 0 && world.field_73012_v.nextInt(100) < (Integer)MidnightConfig.logic.bladeshroomDamageChance.get()) {
                player.func_70097_a(BLADESHROOM_DAMAGE, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Override
    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.NONE;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (state.func_177229_b(STAGE) == Stage.CAPPED) {
            entity.func_70097_a(BLADESHROOM_DAMAGE, 1.0f);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (random.nextInt(10) == 0) {
            this.incrementStage((World)world, pos, state);
        }
    }

    private void incrementStage(World world, BlockPos pos, BlockState state) {
        Stage nextStage = ((Stage)((Object)state.func_177229_b(STAGE))).next();
        if (nextStage == null) {
            return;
        }
        world.func_175656_a(pos, (BlockState)state.func_206870_a(STAGE, (Comparable)((Object)nextStage)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE, FACING});
    }

    @Override
    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return state.func_177229_b(STAGE) != Stage.CAPPED;
    }

    @Override
    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        this.incrementStage((World)world, pos, state);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)MidnightItems.BLADESHROOM_SPORES);
    }

    public static enum Stage implements IStringSerializable
    {
        SPORE,
        STEM,
        CAPPED;


        @Nullable
        public Stage next() {
            Stage[] stages = Stage.values();
            int ordinal = this.ordinal();
            if (ordinal < stages.length - 1) {
                return stages[ordinal + 1];
            }
            return null;
        }

        public static Stage deserialize(int meta) {
            Stage[] stages = Stage.values();
            return stages[meta % stages.length];
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

