/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.block.MidnightPlantBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MidnightDoublePlantBlock
extends MidnightPlantBlock {
    protected static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public MidnightDoublePlantBlock(Block.Properties properties, boolean glowing) {
        super(properties, glowing);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196271_a(BlockState currentState, Direction updatedDirection, BlockState updatedState, IWorld world, BlockPos currentPos, BlockPos updatedPos) {
        if (updatedDirection.func_176740_k() == Direction.Axis.Y) {
            DoubleBlockHalf half = (DoubleBlockHalf)currentState.func_177229_b(HALF);
            Direction alternateDirection = this.getAlternateDirection(currentState);
            if (alternateDirection == updatedDirection && (updatedState.func_177230_c() != this || updatedState.func_177229_b(HALF) == half)) {
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        return super.func_196271_a(currentState, updatedDirection, updatedState, world, currentPos, updatedPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        BlockState state = this.getBaseStateForPlacement(context);
        if (state == null) {
            return null;
        }
        World world = context.func_195991_k();
        BlockPos alternatePos = this.getAlternatePos(pos, state);
        if (alternatePos.func_177956_o() >= world.getMaxHeight() || !world.func_180495_p(alternatePos).func_196953_a(context)) {
            return null;
        }
        return state;
    }

    @Nullable
    protected BlockState getBaseStateForPlacement(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos alternatePos = this.getAlternatePos(pos, state);
        DoubleBlockHalf alternateHalf = this.getAlternateHalf((DoubleBlockHalf)state.func_177229_b(HALF));
        world.func_180501_a(alternatePos, (BlockState)state.func_206870_a(HALF, (Comparable)alternateHalf), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return this.isValidBasePosition(state, world, pos);
        }
        BlockPos alternatePos = this.getAlternatePos(pos, state);
        BlockState alternateState = world.func_180495_p(alternatePos);
        if (state.func_177230_c() != this) {
            return this.isValidBasePosition(state, world, pos);
        }
        return alternateState.func_177230_c() == this && alternateState.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    private boolean isValidBasePosition(BlockState state, IWorldReader world, BlockPos pos) {
        Direction down = this.getDownDirection(state);
        BlockPos attachedPos = pos.func_177972_a(down);
        return this.func_200014_a_(world.func_180495_p(attachedPos), (IBlockReader)world, attachedPos);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos alternatePos = this.getAlternatePos(pos, state);
        BlockState alternateState = world.func_180495_p(alternatePos);
        if (alternateState.func_177230_c() == this) {
            world.func_180501_a(alternatePos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, alternatePos, Block.func_196246_j((BlockState)alternateState));
            if (!world.field_72995_K && !player.func_184812_l_()) {
                MidnightDoublePlantBlock.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
                MidnightDoublePlantBlock.func_220054_a((BlockState)alternateState, (World)world, (BlockPos)alternatePos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    @Override
    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return false;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    @Override
    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos.func_177956_o() : this.getAlternatePos(pos, state).func_177956_o()), (int)pos.func_177952_p());
    }

    @Override
    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF});
    }

    protected BlockPos getAlternatePos(BlockPos pos, BlockState state) {
        return pos.func_177972_a(this.getAlternateDirection(state));
    }

    protected DoubleBlockHalf getAlternateHalf(DoubleBlockHalf half) {
        return half == DoubleBlockHalf.LOWER ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER;
    }

    protected Direction getAlternateDirection(BlockState state) {
        Direction down = this.getDownDirection(state);
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? down.func_176734_d() : down;
    }

    protected Direction getDownDirection(BlockState state) {
        return Direction.DOWN;
    }

    public static void placeAt(IWorld world, BlockPos pos, BlockState state, int flags) {
        BlockState lowerState = (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        BlockState upperState = (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER);
        world.func_180501_a(pos, lowerState, flags);
        world.func_180501_a(pos.func_177984_a(), upperState, flags);
    }
}

